def getWmqQueueConfigProps(deployed, includeEmpty=False):
    """Return validated list of exposed properties with excluded properties not applicable for the deployed to container
    * deployed - deployed instance
    * includeEmpty - set the value of null properties to empty so they are included in the Admin command"""
    exposedProperties = excludeUnsupportedProperties(deployed, deployed.getExposedProperties(True))

    # validate property values
    # invalid values or their combinations will raise a warning or error
    if exposedProperties.get('specifiedPriority', 0) != 0 and exposedProperties.get('priority') != 'SPECIFIED':
        print "WARN: Specified priority value is ignored unless priority is set to SPECIFIED."

    if exposedProperties.get('specifiedExpiry', 0) != 0 and exposedProperties.get('expiry') != 'SPECIFIED':
        print "WARN: Specified expiry value is ignored unless expiry is set to SPECIFIED."

    # include properties without value in the args string
    # these properties will be included in the modify operation to reset the previous values on the WAS resource
    if includeEmpty:
        for key in [key for key in exposedProperties.keys() if exposedProperties[key] is None]:
            exposedProperties[key] = noneToEmpty(exposedProperties[key])

    return exposedProperties

def inspectWmqQueuesCallback(deployedId, jmsName, jmsId, container, prototype):
    """JMS inspect callback for WMQ objects"""
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append('name')
    inspectDeployedProperties(deployedId, jmsName, jmsId, prototype, ignoredProps)
    inspectNestedJ2EEResourceProperties(deployedId, jmsId, "propertySet", "customProperties")

def excludeUnsupportedProperties(deployed, exposedProperties):
    """Configure property values for specific WAS version. Properties not applicable
    to the current container version will be removed from the property set.
    * deployed - deployed instance
    * exposedProperties - properties exposed by the CI to the container"""
    invalidAttrs = getUnsupportedTypeAttrs(deployed.wasType, exposedProperties.keys())
    for invalidAttr in invalidAttrs:
        del exposedProperties[invalidAttr]
    return exposedProperties

def getUnsupportedTypeAttrs(wasType, attributes):
    """Diff the CI attributes and container supported attributes and return the list of attributes
    not supported by the container instance.
    * wasType - name of the AdminConfig object type as in XML configuration files
    * attributes - CI property names
    """
    supportedAttrs = getConfigTypeAttrs(wasType)
    invalidAttrs = [attr for attr in attributes if attr not in supportedAttrs]
    if invalidAttrs:
        print "WARN: Following properties are ignored for the current WAS Server version: %s" % invalidAttrs
    return invalidAttrs

def getConfigTypeAttrs(wasType):
    """Return the list of top level properties for the given wasType.
    * wasType - name of the AdminConfig object type as in XML configuration files"""
    cmdOut = AdminConfig.attributes(wasType)
    propertyLines = cmdOut.splitlines()
    propertyNames = [x.split()[0] for x in propertyLines]
    return propertyNames
