/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.was.deployed.jms.mq.TargetClient;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAS410WmqQueueMigration
extends Upgrade {
    public static final List<String> TYPES_TO_UPGRADE = Lists.newArrayList((Object[])new String[]{"was.WmqQueue", "was.WmqQueueSpec"});
    public static final String PROPERTY_USE_RFH2 = "useRFH2";
    public static final String PROPERTY_TARGET_CLIENT = "targetClient";
    private static final Logger logger = LoggerFactory.getLogger(WAS410WmqQueueMigration.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting WAS plugin 4.1.0 upgrade -- Migrate WMQQueue type ***");
        this.upgradeWmqQueues(repository);
        logger.info("*** Done WAS plugin 4.1.0 upgrade -- Migrate WMQQueue type ***");
        return true;
    }

    private void upgradeWmqQueues(RawRepository repository) {
        for (String typeToUpgrade : TYPES_TO_UPGRADE) {
            List wmqQueueNodes = repository.findNodesByType(Type.valueOf((String)typeToUpgrade));
            try {
                for (Node wmqQueueNode : wmqQueueNodes) {
                    if (!wmqQueueNode.hasProperty(PROPERTY_USE_RFH2)) continue;
                    logger.info("Migrating WMQQueue: {}", (Object)wmqQueueNode.getPath());
                    Property useRFH2 = wmqQueueNode.getProperty(PROPERTY_USE_RFH2);
                    String targetClient = "true".equals(useRFH2.getString()) ? TargetClient.JMS.toString() : TargetClient.MQ.toString();
                    useRFH2.remove();
                    wmqQueueNode.setProperty(PROPERTY_TARGET_CLIENT, targetClient);
                }
            }
            catch (RepositoryException e) {
                throw new UpgradeException("*** Failed WAS plugin 4.1.0 upgrade -- Migrate WMQQueue type ***", (Exception)((Object)e));
            }
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"was-plugin", (String)"4.1.0");
    }
}

