def getWmqQueueConfigProps(deployed, includeEmpty=False):
    """Return validated list of exposed properties with excluded properties not applicable for the deployed to container
    * deployed - deployed instance
    * includeEmpty - set the value of null properties to empty so they are included in the Admin command"""
    exposedProperties = excludeUnsupportedProperties(deployed, deployed.getExposedProperties(True))

    # validate property values
    # invalid values or their combinations will raise a warning or error
    if exposedProperties.get('specifiedPriority', 0) != 0 and exposedProperties.get('priority') != 'SPECIFIED':
        print "WARN: Specified priority value is ignored unless priority is set to SPECIFIED."

    if exposedProperties.get('specifiedExpiry', 0) != 0 and exposedProperties.get('expiry') != 'SPECIFIED':
        print "WARN: Specified expiry value is ignored unless expiry is set to SPECIFIED."

    # include properties without value in the args string
    # these properties will be included in the modify operation to reset the previous values on the WAS resource
    if includeEmpty:
        exposedProperties = allNoneToEmpty(exposedProperties)

    return exposedProperties

def inspectWmqQueuesCallback(deployedId, jmsName, jmsId, container, prototype):
    """JMS inspect callback for WMQ objects"""
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append('name')
    inspectDeployedProperties(deployedId, jmsName, jmsId, prototype, ignoredProps)
    inspectNestedJ2EEResourceProperties(deployedId, jmsId, "propertySet", "customProperties")