/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor.webserver;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.contributor.CollectDeployedsOfTypesContributor;
import com.xebialabs.deployit.plugin.was.contributor.webserver.task.CellTasks;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.was.util.Predicates;
import java.util.Set;

public class GlobalWebServerPluginConfigurationContributor
extends CollectDeployedsOfTypesContributor<ExtensibleDeployedArtifact> {
    private static final String CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY = "updateGlobalPlugin";
    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE = com.google.common.base.Predicates.or(Predicates.instanceOf(Type.valueOf((String)"was.EarModule")), Predicates.instanceOf(Type.valueOf((String)"was.WarModule")));

    public GlobalWebServerPluginConfigurationContributor() {
        super(Type.valueOf(ExtensibleDeployedArtifact.class));
    }

    @Contributor
    public void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext ctx) {
        this.filterDeltas(deltas.getDeltas());
        for (Cell cell : this.getReferencedCells()) {
            if (!Boolean.TRUE.equals(cell.getProperty(CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY))) continue;
            CellTasks.updateGlobalPlugin(cell, ctx);
            CellTasks.propagateGlobalPlugin(cell, ctx);
        }
    }

    protected Set<Cell> getReferencedCells() {
        ImmutableSet.Builder cells = ImmutableSet.builder();
        for (ExtensibleDeployedArtifact earOrWarModule : this.getEarAndWarModules()) {
            cells.add((Object)((WasContainer)earOrWarModule.getContainer()).getCell());
        }
        return cells.build();
    }

    private Set<ExtensibleDeployedArtifact> getEarAndWarModules() {
        ImmutableSet.Builder earAndWarModules = ImmutableSet.builder();
        earAndWarModules.addAll(Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsCreated, (Iterable)this.deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable earAndWarModuleDeltas = Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsModified, (Iterable)this.deployedsNoop), (Predicate)new Predicate<CollectDeployedsOfTypesContributor.TypedDelta>(){

            public boolean apply(CollectDeployedsOfTypesContributor.TypedDelta input) {
                return IS_EAR_OR_WAR_MODULE.apply(input.getDeployed());
            }
        });
        for (CollectDeployedsOfTypesContributor.TypedDelta earOrWarModuleDelta : earAndWarModuleDeltas) {
            earAndWarModules.add(earOrWarModuleDelta.getPrevious());
            earAndWarModules.add(earOrWarModuleDelta.getDeployed());
        }
        return earAndWarModules.build();
    }
}

