package com.xebialabs.deployit.plugin.was.contributor.webserver;


import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.contributor.webserver.task.ManagedWebServerTasks;

import static java.lang.Boolean.TRUE;

public class RestartReferencedWebserversContributor extends AbstractReferencedWebserverContributor {
    static final String WEBSERVER_RESTART_REQUIRED_PROPERTY = "restartRequired";

    /**
     * RestartReferencedWebservers#restartWebservers contributor will add steps to restart referenced managed web
     * servers if managed web servers have property restartRequired set to TRUE.
     */
    @Contributor
    public void restartWebservers(Deltas deltas, DeploymentPlanningContext ctx) {
        filterDeltas(deltas.getDeltas());

        for (ManagedWebServer webserver : getReferencedWebservers(ctx)) {
            // may be null
            if (TRUE.equals(webserver.getProperty(WEBSERVER_RESTART_REQUIRED_PROPERTY))) {
                ManagedWebServerTasks.restart(webserver, ctx);
            }
        }
    }
}
