/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.contributor.CollectDeployedsOfTypesContributor;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;
import com.xebialabs.deployit.plugin.was.util.Predicates;
import java.util.Map;

public class UpdateJaasAliasContributor
extends CollectDeployedsOfTypesContributor<ExtensibleDeployedResource> {
    private static final Type DATASOURCE_TYPE = Type.valueOf((String)"was.Datasource");
    private static final Type JAAS_ALIAS_TYPE = Type.valueOf((String)"was.JaasAlias");
    private static final String UPDATE_JAAS_SCRIPT_PROPERTY = "updateJaasScript";
    private static final String UPDATE_JAAS_ORDER_PROPERTY = "updateJaasOrder";

    public UpdateJaasAliasContributor() {
        super(Lists.newArrayList((Object[])new Type[]{DATASOURCE_TYPE, JAAS_ALIAS_TYPE}));
    }

    @Contributor
    public void addUpdateStepToPlan(Deltas deltas, DeploymentPlanningContext ctx) {
        this.filterDeltas(deltas.getDeltas());
        this.addUpdateJaasAliasStep(ctx);
    }

    private void addUpdateJaasAliasStep(DeploymentPlanningContext ctx) {
        Iterable deployeds = Iterables.concat((Iterable)this.deployedsCreated, (Iterable)Iterables.transform((Iterable)this.deployedsModified, Predicates.extractDeployed()), (Iterable)this.deployedsRemoved);
        for (Deployed d : deployeds) {
            UpdateJaasAliasContributor.addUpdateJaasStep((ExtensibleDeployedResource)d, ctx);
        }
    }

    public static void addUpdateJaasStep(ExtensibleDeployedResource datasource, DeploymentPlanningContext ctx) {
        ctx.addStep((Step)new PythonDeploymentStep(((Integer)datasource.getProperty(UPDATE_JAAS_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)((WasContainer)datasource.getContainer()).getCell(), (String)datasource.getProperty(UPDATE_JAAS_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"deployed", (Object)((Object)datasource)), String.format("Update J2C authentication data at run time", new Object[0])));
    }
}

