import sys

def createServer(nodeName, serverName, template):
    args = ['-name', serverName]
    if template is not None and template != '':
      args.append('-templateName')
      args.append(template)
    args = listToAdminTaskArgs(args)
    print "Creating server '%s' on node '%s': %s" % (serverName, nodeName, args)
    AdminTask.createApplicationServer(nodeName, args)

def checkIfServerExists(nodeName, serverName):
    server = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    if server != "":
        print "WARN: Server '%s' already exists on node '%s'. Doing nothing." % (serverName, nodeName)
        sys.exit(0)

template = parameters.template
nodeName = container.nodeName
serverName = container.name

# ilx: do not create server if it should be part of a cluster?
checkIfServerExists(nodeName, serverName)
createServer(nodeName, serverName, template)

saveConfiguration()
syncNode(nodeName)

