#
providerContainmentPath = '%s/JDBCProvider:%s' % (deployed.container.containmentPath, deployed.jdbcProvider)
providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot locate JDBC Provider '%s' in the container '%s'" % (deployed.jdbcProvider, deployed.container.name))

jaasAliasName = createOrModifyJaasAuthenticationData(deployed)

args = [
    ['name', deployed.name],
    ['jndiName', deployed.jndiName],
    ['datasourceHelperClassname', deployed.datasourceHelperClassname],
    ['authDataAlias', noneToEmpty(jaasAliasName)],
    ['description', noneToEmpty(deployed.description)],
    ['xaRecoveryAuthAlias', mapToEmptyList(jaasAliasName, deployed.useJaasAliasForXaRecovery)]
]

dataSourceId = findDataSourceId(deployed)
if dataSourceId:
    print "Modifying JDBC DataSource '%s' with the arguments '%s'" % (deployed.name, args)
    AdminConfig.modify(dataSourceId, args)
else:
    print "Creating JDBC DataSource '%s' with the arguments '%s' in the container '%s" % (deployed.name, args, deployed.container.name)
    dataSourceId = AdminConfig.create('DataSource', providerId, args)

configureDataSourceConnectionPool(deployed, dataSourceId)

if deployed.containerManagedPersistence:
    if not findCmpConnectorFactory(deployed, dataSourceId):
        createCmpConnectorFactory(deployed, dataSourceId)
else:
    if findCmpConnectorFactory(deployed, dataSourceId):
        removeCmpConnectorFactory(deployed, dataSourceId)

# Reset custom property contents
propertySet = AdminConfig.create('J2EEResourcePropertySet', dataSourceId, [], 'propertySet')
for propName, propValue in deployed.getExposedProperties(True).items():
    args = [['name', propName],['value', propValue]]
    print "Creating Custom Property '%s' " % (args)
    AdminConfig.create('J2EEResourceProperty', propertySet, args)
createCustomProps(propertySet, "J2EEResourceProperty", deployed)

createOrModifyMappingModule(deployed, dataSourceId, jaasAliasName)
