import time
from  com.ibm.ws.scripting import ScriptingException

#
# util
#
def nodeAgentMBean(cellName, nodeName):
  nodeAgentObjectName = AdminControl.completeObjectName('cell=%s,node=%s,process=nodeagent,type=NodeAgent,*' % (cellName, nodeName))
  if nodeAgentObjectName == '':
    raise 'Unable to get object name of node agent on cell %s and node %s. Is nodeagent running?' % (cellName, nodeName)
  return nodeAgentObjectName

def findServerId(nodeName, serverName):
    serverId = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    return serverId

def isServerRunning(cellName, nodeName, serverName):
  nodeAgentBeanName = nodeAgentMBean(cellName, nodeName)
  serverStatus = getServerStatus(cellName, nodeName, serverName)
  if serverStatus == 'RUNNING':
    return True
  else:
    return False

def getServerStatus(cellName, nodeName, serverName):
  nodeAgentBeanName = nodeAgentMBean(cellName, nodeName)
  return AdminControl.invoke(nodeAgentBeanName, 'getProcessStatus', serverName).upper()

def failIfServerNotRunning(cellName, nodeName, serverName):
    serverStatus = getServerStatus(cellName, nodeName, serverName)
    if serverStatus != 'RUNNING':
        print "ERROR: Server %s on %s:%s did not start immediately. Current status: %s." % (server.name, server.cellName,
                                                                                            server.nodeName, serverStatus)
        sys.exit(1)

def failIfServerNotStopped(cellName, nodeName, serverName):
    serverStatus = getServerStatus(cellName, nodeName, serverName)
    if serverStatus != 'STOPPED':
        print "ERROR: Web Server %s on %s:%s did not start immediately. Current status: %s." % (server.name, server.cellName,
                                                                                                server.nodeName, serverStatus)
        sys.exit(1)

def waitUntil(state, failure, cellName, nodeName, serverName, maxRetries, sleepTime):
  serverStatus = getServerStatus(cellName, nodeName, serverName)
  retry = 0
  while retry < maxRetries and not serverStatus == state:
    retry = retry + 1
    print "Attempt: %s. Server %s on %s:%s is: %s." % (retry, serverName, cellName, nodeName, serverStatus)
    time.sleep(sleepTime)
  serverStatus = getServerStatus(cellName, nodeName, serverName)
  if not serverStatus == state:
    raise failure
  else:
    print "SUCCESS: Server %s on %s:%s is: %s:%s." % (serverName, cellName, nodeName, serverStatus, state)
#
# start
#
def startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime):
  retry = 0
  while retry < maxRetries:
      retry = retry + 1
      try:
          serverStatus = getServerStatus(cellName, nodeName, serverName)
          if 'RUNNING' != serverStatus and 'STARTING' != serverStatus:
              nodeAgentBeanName = nodeAgentMBean(cellName, nodeName)
              AdminControl.invoke(nodeAgentBeanName, 'launchProcess', serverName)
              waitUntil('RUNNING', 'Server did not start in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
      except:
          serverStatus = getServerStatus(cellName, nodeName, serverName)
          if 'RUNNING' == serverStatus:
              break
          print "Server %s on %s:%s did not start immediately. Current status: %s. Will wait %s seconds and try again." % (serverName, cellName, nodeName, serverStatus, sleepTime)
          time.sleep(sleepTime)

def startServer(cellName, nodeName, serverName, maxRetries, sleepTime):
  sleepTime = 5
  maxRetries = 5
  serverStatus = getServerStatus(cellName, nodeName, serverName)
  if 'FAILED' == serverStatus:
    raise "ERROR: Server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
  elif 'RUNNING' == serverStatus:
    print "INFO: Server %s on %s:%s is %s. Nothing to do." % (serverName, cellName, nodeName, serverStatus)
  elif 'STARTING' == serverStatus:
    waitUntil('RUNNING', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
  elif 'STOPPING' == serverStatus:
    waitUntil('STOPPED', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
    startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)
  else:
    startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)

#
# stop
#
def stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime):
  retry = 0
  while retry < maxRetries:
      retry = retry + 1
      try:
          serverStatus = getServerStatus(cellName, nodeName, serverName)
          if 'STOPPED' != serverStatus and 'STOPPING' != serverStatus:
              nodeAgentBeanName = nodeAgentMBean(cellName, nodeName)
              AdminControl.invoke(nodeAgentBeanName, 'terminate', serverName)
              waitUntil('STOPPED', 'Server did not stop in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
      except:
          serverStatus = getServerStatus(cellName, nodeName, serverName)
          if 'STOPPED' == serverStatus:
              break
          print "Server %s on %s:%s did not stop immediately. Current status: %s. Will wait %s seconds and try again." % (serverName, cellName, nodeName, serverStatus, sleepTime)
          time.sleep(sleepTime)

def stopServer(cellName, nodeName, serverName, maxRetries, sleepTime):
  serverStatus = getServerStatus(cellName, nodeName, serverName)
  if 'FAILED' == serverStatus:
    raise "Server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
  elif 'STOPPED' == serverStatus:
    print "Server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
  elif 'STARTING' == serverStatus:
    waitUntil('RUNNING', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
    stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)
  elif 'STOPPING' == serverStatus:
    waitUntil('STOPPED', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
  else:
    stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)

try:
    server = container
except NameError:
    server = deployed

serverId = findServerId(nodeName, serverName)
exitWithMessageIfEmpty(serverId, "ERROR: Server '%s' does not exist on node '%s'." % (serverName, nodeName), 1)

stopServer(server.cellName, server.nodeName, server.name, server.maxRetries, server.sleepTime)
failIfServerNotStopped(server.cellName, server.nodeName, server.name)

startServer(server.cellName, server.nodeName, server.name, server.maxRetries, server.sleepTime)
failIfServerNotRunning(server.cellName, server.nodeName, server.name)
