#
################################################################################################################
# General utility functions
################################################################################################################
def getParentOfType(childId, childType, parentType):
    for c in findAllContainers(container):
        for parentId in wsadminToList(AdminConfig.getid("%s/%s:/" % (c.containmentPath, parentType))):
            results = AdminConfig.list(childType, parentId)
            if childId in wsadminToList(results):
                return parentId

################################################################################################################
# J2C utility functions
################################################################################################################
def getJ2CResourceAdapter(deployed):
    name = deployed.name
    if hasattr(deployed, 'provider'):
        name = deployed.provider
    providerContainmentPath = '%s/J2CResourceAdapter:%s' % (deployed.container.containmentPath, name)
    providerId = AdminConfig.getid(providerContainmentPath)
    if providerId == "":
        print "Cannot find WebSphere J2C Resource Adapter '%s' on container '%s'" % (name, deployed.container.name)
        #ResourceAdapter names all start with Application name followed by a '.', <Application>.<ResourceAdapterName>
        appName = '.'.join(name.split('.')[:-1])
        validateNotEmpty(appName, "Provider not set or does not contain application name. '%s' was provided" % (name))
        print "Searching for J2C Resource Adapter within enterprise applications..."
        providerId = getEmbeddedJ2CResourceAdapter(appName)
    return providerId

def getEmbeddedJ2CResourceAdapter(application):
    providerPath = "/Deployment:%s/" % (application)
    deploymentId = validateNotEmpty(AdminConfig.getid(providerPath),
                                    "Cannot find Embedded Resource Adapter in '%s'" % (application))
    try:
        deploymentObject = AdminConfig.showAttribute(deploymentId, 'deployedObject')
        if AdminConfig.getObjectType(deploymentObject) == "ApplicationDeployment":
            modulesObject = wsadminToList(AdminConfig.showAttribute(deploymentObject, 'modules'))
            for module in modulesObject:
                if AdminConfig.getObjectType(module) == "ConnectorModuleDeployment":
                    resourceAdapterId = AdminConfig.showAttribute(module, 'resourceAdapter')
                    return resourceAdapterId
    except:
        error = "Cannot find embedded J2C Resource Adapter '%s'" % name
        printErrorAndExit(error)

def discoverAndInspectJ2CObjectProperties(canHandleContainerPropertyTypeCallback=None, containerPropertyInspectCallback=None, listObjectsInContainerCallback=None):
    if containerPropertyInspectCallback is None:
        containerPropertyInspectCallback = inspectDeployedProperties
    for c in findAllContainers(container):
        inspectAdminConfigPropertiesCallback(c, prototype, canHandleContainerPropertyTypeCallback, containerPropertyInspectCallback, listObjectsInContainerCallback)

def destroyJ2CObject(deployed):
    for id in  wsadminToList(AdminConfig.list(deployed.wasType, getJ2CResourceAdapter(deployed))):
        if AdminConfig.showAttribute(id, "name") == deployed.name:
            print "Destroying %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
            AdminConfig.remove(id)
            return
    printErrorAndExit("Cannot find %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name))

def listJ2CResourceAdaptersInContainerCallback(container, prototype):
    return wsadminToList(AdminConfig.getid('%s/J2CResourceAdapter:/' % container.containmentPath))

def listJ2CObjectsInContainerCallback(container, prototype):
    providerIds = listJ2CResourceAdaptersInContainerCallback(container, prototype)

    ignoredProviderNames = prototype.standardProvidersToIgnore.split(",")
    if prototype.additionalProvidersToIgnore:
        ignoredProviderNames.extend(prototype.additionalProvidersToIgnore.split(","))

    discoveredJ2CObjects = []
    for providerId in providerIds:
        providerName = AdminConfig.showAttribute(providerId, "name")
        if providerName not in ignoredProviderNames:
            discoveredJ2CObjects.extend(wsadminToList(AdminConfig.list(prototype.wasType, providerId)))

    return discoveredJ2CObjects
