#
def discoverAndInspectSibConnectionFactories(container):
    containerid = AdminConfig.getid(container.containmentPath)
    connectionFactories = ""
    try:
        connectionFactories = AdminTask.listSIBJMSConnectionFactories(containerid, "-type %s" % prototype.sibType)
    except:
        print "WARNING: Unable to find SIBJMSConnectionFactory on container: %s" % (containerid)

    if connectionFactories != "":
        for cf in connectionFactories.splitlines():
            deployedName = AdminConfig.showAttribute(cf, 'name')
            deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectSibConnectionFactory(deployedId, deployedName, cf, container)
            inspectedItem(deployedId)



def inspectSibConnectionFactory(deployedId, jmsName, jmsId, container):
    inspectedProperty(deployedId, 'jndiName', AdminConfig.showAttribute(jmsId, 'jndiName'))
    propertySet = AdminConfig.showAttribute(jmsId, 'propertySet')
    resourceProperties = AdminConfig.showAttribute(propertySet, 'resourceProperties')[1:-1].split(' ')
    for p in resourceProperties:
        pname = AdminConfig.showAttribute(p, 'name')
        pname = pname[0:1].lower() + pname[1:]
        pvalue = AdminConfig.showAttribute(p, 'value')
        if pvalue != None:
            inspectedProperty(deployedId, pname, pvalue)


for c in findAllContainers(container):
    discoverAndInspectSibConnectionFactories(c)
