/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAS410WmqConnectionFactoryMigration
extends JcrUpgrade {
    public static final List<String> TYPES_TO_UPGRADE = Lists.newArrayList((Object[])new String[]{"was.WmqQueueConnectionFactory", "was.WmqQueueConnectionFactorySpec"});
    private static final Logger logger = LoggerFactory.getLogger(WAS410WmqConnectionFactoryMigration.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***");
        this.upgradeWmqQueueConnectionFactories(repository);
        logger.info("*** Done WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***");
        return true;
    }

    private void upgradeWmqQueueConnectionFactories(RawRepository repository) {
        for (String typeToUpgrade : TYPES_TO_UPGRADE) {
            List wmqQcfNodes = repository.findNodesByType(Type.valueOf((String)typeToUpgrade));
            try {
                for (Node wmqQcfNode : wmqQcfNodes) {
                    if (!wmqQcfNode.hasProperty("sslConfiguration")) continue;
                    logger.info("Migrating WMQQueueConnectionFactory: {}", (Object)wmqQcfNode.getPath());
                    String sslConfigurationName = "";
                    Property sslConfiguration = wmqQcfNode.getProperty("sslConfiguration");
                    Node sslConfigurationNode = sslConfiguration.getNode();
                    if (sslConfigurationNode != null && sslConfigurationNode.hasProperty("sslConfigName")) {
                        sslConfigurationName = sslConfigurationNode.getProperty("sslConfigName").getString();
                    }
                    sslConfiguration.remove();
                    wmqQcfNode.setProperty("sslConfigurationName", sslConfigurationName);
                }
            }
            catch (RepositoryException e) {
                throw new UpgradeException("*** Failed WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***", (Exception)((Object)e));
            }
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"was-plugin", (String)"4.1.0");
    }
}

