$msiLog = "msiexec-log.txt"

$msiArgs = @()
$msiArgs += "/i"
$msiArgs += $deployed.file
if ($deployed.installProperties) {
    $msiArgs += $deployed.installProperties
}
if ($deployed.logOptions) {
    $msiArgs += "/L$($deployed.logOptions) $msiLog"
}
$msiArgs += "/qn"

Write-Output "Installing MSI for application [$($deployed.name)] with arguments [$($msiArgs)]"
Start-Process -FilePath msiexec -ArgumentList $msiArgs -Wait 

if(!$?) {
    Write-Output "Cannot start MSI installation"
    Exit 1
}

if ($deployed.logOptions) {
    Write-Output ""
    Get-Content $msiLog
    Write-Output ""
    Remove-Item $msiLog
}

Write-Output "Starting service [$($deployed.serviceName)]"
Start-Service $deployed.serviceName
