#
from wlp.modules.utility import Paths
from com.xebialabs.deployit.plugin.api.deployment.specification import Operation
from com.xebialabs.deployit.plugin.api.deployment.planning import DefaultOrders

context.addStepWithCheckpoint(steps.upload(
    description="Upload application '%s' to server '%s'" % (deployed.name, deployed.container.name),
    target_path=Paths.get_target_path(deployed),
    order=DefaultOrders.DEPLOY_ARTIFACTS
), delta, Operation.CREATE)
context.addStepWithCheckpoint(steps.jython(
    description="Create '%s' application entry on server '%s'" % (deployed.name, deployed.container.name),
    script="wlp/scripts/resource/create-modify-resource.py",
    order=DefaultOrders.DEPLOY_ARTIFACTS + 1
), delta, Operation.CREATE)
if deployed.restartStrategy == "STOP_START":
    context.addStep(steps.jython(
        description="Start application '%s' on server '%s'" % (deployed.name, deployed.container.name),
        order=DefaultOrders.START_ARTIFACTS,
        script="wlp/scripts/application/start-application.py",
        jython_context={"thisCi": deployed}
    ))