/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.freemarker;

import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEvaluator {
    protected static final Logger logger = LoggerFactory.getLogger(TemplateEvaluator.class);

    public static void evaluateTemplate(OverthereFile renderTo, final String templatePath, Map<String, Object> vars) {
        OutputStream out = renderTo.getOutputStream();
        TemplateEvaluator.processTemplate(new OutputStreamWriter(out), vars, new TemplateCreator(){

            @Override
            public Template getTemplate() throws IOException {
                return ConfigurationHolder.getConfiguration().getTemplate(templatePath);
            }
        });
    }

    public static String evaluateExpression(final String expression, Map<String, Object> vars) {
        StringWriter out = new StringWriter();
        TemplateEvaluator.processTemplate(out, vars, new TemplateCreator(){

            @Override
            public Template getTemplate() throws IOException {
                return new Template("TempTemplate", (Reader)new StringReader(expression), ConfigurationHolder.getConfiguration());
            }
        });
        return out.toString();
    }

    private static void processTemplate(Writer outputWriter, Map<String, Object> vars, TemplateCreator creator) {
        try {
            Template template = creator.getTemplate();
            template.process(vars, outputWriter);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly(outputWriter);
        }
    }

    private static interface TemplateCreator {
        public Template getTemplate() throws IOException;
    }
}

