/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedInspectionHelper {
    public static final String DISCOVER_SCRIPT_PROPERTY_NAME = "discoverScript";
    private static Logger logger = LoggerFactory.getLogger(DelegatedInspectionHelper.class);

    public static void discoverDeployeds(PythonManagedContainer container, InspectionContext ctx) {
        DelegatedInspectionHelper.discoverDeployeds(container, ctx, DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonManagedDeployed.class)));
    }

    public static void discoverDeployeds(PythonManagedContainer container, InspectionContext ctx, Iterable<Type> types) {
        Multimap<Integer, PythonInspectionStep> steps = DelegatedInspectionHelper.newSortedKeyMultimapForSteps();
        Type containerT = container.getType();
        for (Type deployedT : types) {
            Descriptor deployedD = deployedT.getDescriptor();
            logger.debug("Checking whether type [{}] is not virtual", (Object)deployedT);
            if (deployedD.isVirtual()) continue;
            Type deployedContainerT = deployedD.getContainerType();
            Type wasContainerT = Type.valueOf(WlsContainer.class);
            logger.debug("Checking whether type [{}] is instance of type [{}]", (Object)deployedContainerT, (Object)wasContainerT);
            if (!containerT.instanceOf(wasContainerT)) continue;
            logger.debug("Checking whether type [{}] has a discoveryScript property", (Object)deployedT);
            PropertyDescriptor discoveryScriptProperty = deployedD.getPropertyDescriptor(DISCOVER_SCRIPT_PROPERTY_NAME);
            if (discoveryScriptProperty == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a default value", (Object)deployedT);
            Object defaultValue = discoveryScriptProperty.getDefaultValue();
            if (defaultValue == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a string value", (Object)deployedD.getType());
            if (!(defaultValue instanceof String)) continue;
            String scriptName = (String)defaultValue;
            logger.debug("Adding inspection step using script {} for container {}", (Object)scriptName, (Object)container);
            HashMap pythonVars = Maps.newHashMap();
            pythonVars.put("container", container);
            PythonManagedDeployed prototype = (PythonManagedDeployed)deployedD.newInstance(container.getId() + "/prototype");
            pythonVars.put("prototype", prototype);
            PythonInspectionStep step = new PythonInspectionStep((ConfigurationItem)container, container.getManagingContainer(), scriptName, (Map)pythonVars, "Discover objects of type " + deployedT + " on " + container);
            steps.put((Object)prototype.getDiscoverOrder(), (Object)step);
        }
        for (PythonInspectionStep step : steps.values()) {
            ctx.addStep((Step)step);
        }
    }

    private static Multimap<Integer, PythonInspectionStep> newSortedKeyMultimapForSteps() {
        return Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<PythonInspectionStep>>(){

            public List<PythonInspectionStep> get() {
                return Lists.newArrayList();
            }
        });
    }
}

