#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

connectAndEdit()

mailSessionPath = '/MailSessions/%s' % (deployed.name)
if not exists(mailSessionPath):
    print >> sys.stderr, "Mail session with name %s does not exist." %(deployed.name)
    sys.exit(1)

cd(mailSessionPath)
currentTargets = get('Targets')
containerTarget = ObjectName(deployed.container.objectName)
newTargets = []
for t in currentTargets:
    if t != containerTarget:
        newTargets.append(t)

if len(newTargets) > 0:
    print "Modifying mail session %s" % (deployed.name)
    set('Targets', jarray.array(newTargets, ObjectName))
else:
    print "Deleting mail session %s" % (deployed.name)
    cd('/')
    delete(deployed.name, 'MailSessions')

saveAndExit()