/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.FileContainer;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.Server;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="WebLogic Cluster which defines groups of WebLogic servers that work together to increase scalability and reliability")
@TypeIcon(value="icons/types/cluster.svg")
public class Cluster
extends BaseContainer
implements FileContainer,
JmsTarget {
    protected final Map<String, Object> context;
    private static final String START_CONTROL_TASK = "start";
    private static final String STOP_CONTROL_TASK = "stop";
    @Property(required=true, asContainment=true, description="The domain to which the WebLogic Cluster belongs. 'asContainment'=true, means a Cluster is 'contained' under a Domain", category="Topology")
    private Domain domain;
    @Property(description="Servers in the WebLogic Cluster", required=false)
    private Set<Server> servers = new HashSet<Server>();
    @Property(required=true, defaultValue="80", hidden=true)
    private int startOrder;
    @Property(required=true, defaultValue="20", hidden=true)
    private int stopOrder;
    @Property(required=true, hidden=true, defaultValue="1", description="The time to wait in seconds for a container start action.")
    private int startWaitTime;

    public Cluster() {
        this.context = new HashMap<String, Object>();
        this.context.put("container", this);
    }

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Cluster";
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "wls/container/inspect-cluster.py", (Map)pythonVars, "Inspect " + this));
    }

    @Override
    public Set<Host> getHosts() {
        HashSet hosts = Sets.newHashSet();
        for (Server server : this.servers) {
            hosts.addAll(server.getHosts());
        }
        return hosts;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void setServers(Set<Server> servers) {
        this.servers = servers;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public PythonManagingContainer getManagingContainer() {
        return this.domain;
    }

    @Override
    public int getStartOrder() {
        return this.startOrder;
    }

    @Override
    public int getStopOrder() {
        return this.stopOrder;
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        if (name.equals(STOP_CONTROL_TASK)) {
            return this.getStopSteps(1);
        }
        if (name.equals(START_CONTROL_TASK)) {
            return this.getStartSteps(1);
        }
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    public Host getHost() {
        return this.domain.getHost();
    }

    @Override
    public List<Step> getStartSteps(final int order) {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getServers(), (Function)new Function<Server, List<Step>>(){

            public List<Step> apply(Server input) {
                return input.getStartSteps(order);
            }
        })));
    }

    @Override
    public List<Step> getStopSteps(final int order) {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getServers(), (Function)new Function<Server, List<Step>>(){

            public List<Step> apply(Server input) {
                return input.getStopSteps(order);
            }
        })));
    }
}

