/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.Server;
import java.util.List;
import java.util.Map;

@Metadata(description="WebLogic JMS server, that act as management containers for the queues and topics in JMS modules that are targeted to them")
public class JmsServer
extends BaseContainer
implements JmsTarget,
HostContainer {
    @Property(required=true, asContainment=true, description="A server instance or migratable target this JMS server is deployed to. 'asContainment'=true, means a JmsServer is 'contained' under a Server", category="Topology")
    private Server server;

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.server.getDomain();
    }

    @Override
    public Domain getDomain() {
        return this.server.getDomain();
    }

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=JMSServer";
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    public Host getHost() {
        return this.server.getHost();
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
    }
}

