/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiTargetDeploymentStep
extends PythonDeploymentStep {
    private static final Function<StepData, String> GET_TARGET_CONTAINER_NAME = new Function<StepData, String>(){

        public String apply(StepData target) {
            return ((WlsContainer)target.getDeployedArtifact().getContainer()).getName();
        }
    };
    private static final Function<StepData, Delta> GET_DELTA = new Function<StepData, Delta>(){

        public Delta apply(StepData target) {
            return target.getDelta();
        }
    };
    private Collection<Delta> deltas;

    public MultiTargetDeploymentStep(int order, PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        super(order, container, scriptPath, pythonVars, description);
    }

    public static MultiTargetDeploymentStep create(DeploymentPlanningContext ctx, Collection<StepData> singleSteps) {
        StepData singleStep = (StepData)Iterables.getFirst(singleSteps, null);
        List targets = Ordering.natural().sortedCopy((Iterable)ImmutableSet.copyOf((Collection)Collections2.transform(singleSteps, GET_TARGET_CONTAINER_NAME)).asList());
        ArrayList deltas = Lists.newArrayList((Iterable)Collections2.filter((Collection)Collections2.transform(singleSteps, GET_DELTA), (Predicate)Predicates.notNull()));
        Delta delta = (Delta)Iterables.getFirst((Iterable)deltas, null);
        Deployed previousDeployed = delta != null ? delta.getPrevious() : null;
        PythonManagingContainer container = MultiTargetDeploymentStep.getManagingContainer(singleStep.deployedArtifact);
        Map<String, Object> pythonVars = MultiTargetDeploymentStep.buildPythonVars(ctx.getDeployedApplication(), previousDeployed, singleStep.deployedArtifact, targets, singleStep.getOptions());
        String description = MultiTargetDeploymentStep.getDescription(singleStep.verb, singleStep.deployedArtifact, targets);
        MultiTargetDeploymentStep multiStep = new MultiTargetDeploymentStep(singleStep.order, container, singleStep.scriptPath, pythonVars, description);
        multiStep.setUploadArtifactData(singleStep.options.contains("uploadArtifactData"));
        multiStep.setDeltas(deltas);
        return multiStep;
    }

    private static PythonManagingContainer getManagingContainer(ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact) {
        return ((WlsContainer)deployedArtifact.getContainer()).getManagingContainer();
    }

    private static Map<String, Object> buildPythonVars(DeployedApplication deployedApplication, Deployed<?, ?> previousDeployed, ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact, Collection<String> targets, Set<String> options) {
        Map<String, Object> pythonVars = deployedArtifact.getPythonVars(previousDeployed, deployedApplication, options);
        pythonVars.put("targets", Joiner.on((String)",").join(targets));
        return pythonVars;
    }

    private static String getDescription(String verb, ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact, Collection<String> targets) {
        return String.format("%s %s on %s: %s", verb, ((DeployableArtifact)deployedArtifact.getDeployable()).getFile().getName(), ((WlsContainer)deployedArtifact.getContainer()).getDomain().getName(), Joiner.on((String)",").join(targets));
    }

    public String getDescription() {
        return super.getDescription();
    }

    public void setDeltas(Collection<Delta> deltas) {
        this.deltas = deltas;
    }

    public Collection<Delta> getDeltas() {
        return this.deltas;
    }

    public static class StepData {
        private final ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact;
        private final int order;
        private final String scriptPath;
        private final String verb;
        private final Delta delta;
        private final Set<String> options;

        public StepData(ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact, int order, String scriptPath, String verb, Set<String> options, Delta delta) {
            this.deployedArtifact = deployedArtifact;
            this.order = order;
            this.scriptPath = scriptPath;
            this.verb = verb;
            this.options = options;
            this.delta = delta;
        }

        public ExtensibleDeployedArtifact<? extends DeployableArtifact> getDeployedArtifact() {
            return this.deployedArtifact;
        }

        public int getOrder() {
            return this.order;
        }

        public String getScriptPath() {
            return this.scriptPath;
        }

        public String getVerb() {
            return this.verb;
        }

        public Set<String> getOptions() {
            return this.options;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Step{");
            sb.append("deployedArtifact=").append(this.deployedArtifact);
            sb.append(", order=").append(this.order);
            sb.append(", scriptPath='").append(this.scriptPath).append('\'');
            sb.append(", verb='").append(this.verb).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

