/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import java.util.HashMap;
import java.util.Map;

@StepMetadata(name="wlst")
public class WlstStep
extends CalculatedStep
implements PreviewStep {
    @StepParameter(description="WebLogic domain where to execute the python script", calculated=true)
    private Domain targetDomain;
    @StepParameter(description="Path to the python script to be executed")
    private String script;
    @StepParameter(description="Dictionary that represent context available to the python script", required=false, calculated=true)
    private Map<String, Object> pythonContext = new HashMap<String, Object>();
    @StepParameter(description="If true, the artifacts from the python context will be uploaded to the target host and available to the script as bindingName.file. Defaults to true.")
    private Boolean uploadArtifactsInPythonContext = true;
    private PythonDeploymentStep pythonStep;

    @RulePostConstruct
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        this.pythonStep = new PythonDeploymentStep(this.getOrder(), (PythonManagingContainer)this.calculateTargetDomain(ctx), this.script, ContextHelper.defaultContext((StepPostConstructContext)ctx, this.pythonContext), this.getDescription());
        this.pythonStep.setUploadArtifactData(this.uploadArtifactsInPythonContext.booleanValue());
    }

    private Domain calculateTargetDomain(StepPostConstructContext ctx) {
        PythonManagedContainer targetContainer;
        if (this.targetDomain == null && (targetContainer = (PythonManagedContainer)TargetContainerJavaHelper.defaultTargetContainer((StepPostConstructContext)ctx, PythonManagedContainer.class)) != null && targetContainer.getManagingContainer() instanceof Domain) {
            this.targetDomain = (Domain)targetContainer.getManagingContainer();
        }
        return this.targetDomain;
    }

    public Preview getPreview() {
        return this.pythonStep.getPreview();
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return this.pythonStep.execute(ctx);
    }
}

