/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A Work Manager in a {@link WlsDomain WLS domain}.
 * <p>
 * Work Managers should be application specific, i.e. not shared between multiple applications running in a domain.
 * 
 * @see WlsMaximumThreadsConstraint
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Work Manager that defines a set of request classes and thread constraints that manage work performed by WebLogic Server instances.")
public class WlsWorkManager extends BaseConfigurationItem implements WlsClusterResource {

	@ConfigurationItemProperty(description = "Name of the Work Manager", required = true, identifying = true)
	private String name;

	@ConfigurationItemProperty
	private WlsMaximumThreadsConstraint maximumThreadsConstraint;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public WlsMaximumThreadsConstraint getMaximumThreadsConstraint() {
		return maximumThreadsConstraint;
	}

	public void setMaximumThreadsConstraint(WlsMaximumThreadsConstraint maximumThreadsConstraint) {
		this.maximumThreadsConstraint = maximumThreadsConstraint;
	}

}
