/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;

/**
 * Creates a {@link WlsJmsQueue}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-queue.py";

	public CreateWlsJmsQueueStep(WlsDomain domain, String jmsModuleName, WlsJmsQueue queue) {
		super("Create JMS Queue " + queue + " in subdeployment " + queue.getJmsServer().getSubdeploymentName(jmsModuleName) + " of module "
				+ jmsModuleName + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(queue, jmsModuleName));
	}

	private static String[] getArgs(WlsJmsQueue queue, String jmsModuleName) {
		List<String> args = new ArrayList<String>();
		args.add(jmsModuleName);
		args.add(queue.getJmsServer().getSubdeploymentName(jmsModuleName));
		args.add(queue.getName());
		args.add(queue.getJndiName());
		args.add(String.valueOf(queue.getRedeliveryDelayOverride() == 0 ? -1 : queue.getRedeliveryDelayOverride()));
		args.add(String.valueOf(queue.getRedeliveryLimits() == 0 ? -1 : queue.getRedeliveryLimits()));
		args.add(queue.getExpirationPolicy() != null ? queue.getExpirationPolicy().name() : "");
		args.add(StringUtils.defaultString(queue.getExpirationLoggingFormat()));
		args.add(queue.getErrorQueue() != null ? queue.getErrorQueue().getName() : "");
		return args.toArray(new String[args.size()]);
	}

}