/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Deploys applications on a {@link com.xebialabs.deployit.plugin.wls.ci.WlsCluster cluster} or {@link com.xebialabs.deployit.plugin.wls.ci.WlsServer managed server}using nostage mode.
 */
@SuppressWarnings("serial")
public class WlsDeployNoStageArtifactStep extends WlsStepBase {

    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = STEP_RESOURCES_PATH + "deploy-nostage-application.py";
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME = STEP_RESOURCES_PATH + "deploy-nostage-plan-application.py";

    private String targetName;

    private String applicationName;

    private String remoteArchivePath;

    private String remoteDeploymentPlanPath;

    public WlsDeployNoStageArtifactStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, String remoteArchivePath) {
        super(wlsTarget.getDomain());
        this.targetName = wlsTarget.getName();
        this.applicationName = artifact.getName();
        this.remoteArchivePath = remoteArchivePath;

        setDescription("Deploy  " + artifact + " on " + wlsTarget + " nostage mode using " + remoteArchivePath);
    }

    @Override
    public String getDescription() {
        String desc = super.getDescription();
        if (!StringUtils.isBlank(remoteDeploymentPlanPath)) {
            desc = desc + " and a deployment plan";
        }
        return desc;
    }


    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = domain.connectToAdminHost();
        try {
            List<String> argsList = new ArrayList<String>();
            argsList.add(domain.getUsername());
            argsList.add(domain.getPassword());
            argsList.add(domain.getConnectUrl());
            argsList.add(targetName);
            argsList.add(applicationName);
            argsList.add(rhs.getFile(this.remoteArchivePath).getPath().replace('\\', '/'));

            String scriptName = DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME;
            if (hasDeploymentPlan()) {
                argsList.add(rhs.getFile(this.remoteDeploymentPlanPath).getPath().replace('\\', '/'));
                scriptName = DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME;
            }
            String[] args = argsList.toArray(new String[argsList.size()]);

            int res = executeWlstJythonScriptResource(ctx, rhs, scriptName, args);
            return res == 0;
        } finally {
            rhs.close();
        }
    }

    public boolean hasDeploymentPlan() {
        return remoteDeploymentPlanPath != null;
    }


    public String getApplicationName() {
        return applicationName;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setRemoteDeploymentPlanPath(String remoteDeploymentPlanPath) {
        this.remoteDeploymentPlanPath = remoteDeploymentPlanPath;
    }
}