/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public abstract class WlstObjectInfoCollectingCallbackHandlerBase implements CommandExecutionCallbackHandler {

	private Map<String, String> objectInfo;

	private boolean collectData;

	public WlstObjectInfoCollectingCallbackHandlerBase() {
		objectInfo = new HashMap<String, String>();
		collectData = false;
	}

	public void handleErrorLine(String line) {
		System.err.println(line);
	}

	public void handleOutput(char c) {
		// no-op
	}

	public void handleOutputLine(String line) {
		if (logger.isDebugEnabled())
			logger.debug("WLST Says:" + line);

		if ("--KOMT IE DAN--".equals(line)) {
			collectData = true;
		} else if ("--WAS IE DAN HE--".equals(line)) {
			collectData = false;
		}
		if (collectData && line.length() > 0) {
			// Example:
			// "-r--   SecurityDDModel                              DDOnly"
			String strippedLine = line.substring("-r--   ".length());
			int keyEndsPosition = strippedLine.indexOf(" ");
			if (keyEndsPosition > 0) {
				String key = strippedLine.substring(0, keyEndsPosition);
				strippedLine = strippedLine.substring(key.length());
				String value = strippedLine.trim();
				objectInfo.put(key, value);
			}
		}
	}

	public boolean isCollectData() {
		return collectData;
	}

	public void setCollectData(boolean collectData) {
		this.collectData = collectData;
	}

	public Map<String, String> getObjectInfo() {
		return objectInfo;
	}

    private static final Logger logger = LoggerFactory.getLogger(WlstObjectInfoCollectingCallbackHandlerBase.class);
}
