/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A JMS queue defined in a WLS {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A WebLogic JMS Queue")
public class WlsJmsQueue extends BaseConfigurationItem implements WlsServerResource {

	@ConfigurationItemProperty
	private WlsJmsServer jmsServer;

	@ConfigurationItemProperty(description = "The name of the queue", required = true, identifying = true)
	private String name;

	@ConfigurationItemProperty(required = true)
	private String jndiName;

	@ConfigurationItemProperty(description = "The name of the target error destination for messages that have expired or reached their redelivery limit")
	private WlsJmsQueue errorQueue;

	@ConfigurationItemProperty(description = "The delay, in milliseconds, before rolled back or recovered messages are redelivered, regardless of the RedeliveryDelay specified by the consumer and/or connection factory")
	private int redeliveryDelayOverride;

	@ConfigurationItemProperty(description = "The number of redelivery attempts a message can make before it is moved to the error destination")
	private int redeliveryLimits;

	@ConfigurationItemProperty(required = true, description = "The message Expiration Policy to use when an expired message is encountered on a destination")
	private ExpirationPolicy expirationPolicy;

	public static enum ExpirationPolicy {
		DISCARD, LOG, REDIRECT
	}

	@ConfigurationItemProperty(description = "The policy that defines what information about the message is logged when the Expiration Policy is set to Log")
	private String expirationLoggingFormat;

	public WlsJmsServer getJmsServer() {
		return jmsServer;
	}

	public void setJmsServer(WlsJmsServer jmsServer) {
		this.jmsServer = jmsServer;
	}


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public WlsJmsQueue getErrorQueue() {
		return errorQueue;
	}

	public void setErrorQueue(WlsJmsQueue errorQueue) {
		this.errorQueue = errorQueue;
	}

	public int getRedeliveryDelayOverride() {
		return redeliveryDelayOverride;
	}

	public void setRedeliveryDelayOverride(int redeliveryDelayOverride) {
		this.redeliveryDelayOverride = redeliveryDelayOverride;
	}

	public int getRedeliveryLimits() {
		return redeliveryLimits;
	}

	public void setRedeliveryLimits(int redeliveryLimits) {
		this.redeliveryLimits = redeliveryLimits;
	}

	public ExpirationPolicy getExpirationPolicy() {
		return expirationPolicy;
	}

	public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
		this.expirationPolicy = expirationPolicy;
	}

	public String getExpirationLoggingFormat() {
		return expirationLoggingFormat;
	}

	public void setExpirationLoggingFormat(String expirationLoggingFormat) {
		this.expirationLoggingFormat = expirationLoggingFormat;
	}
	
}
