/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.Collection;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

@SuppressWarnings("serial")
public class CheckWlsServerIsOnCluster extends WlsStepBase {
	
	public static final String IS_NOT_ON_RESULT = "IS_NOT_ON_CLUSTER";
	public static final String IS_ON_RESULT = "IS_ON_CLUSTER";
	public static final String SERVER_CLUSTER_SEPERATOR = "_ON_";
	
	
	private WlsCluster wlsCluster;
	private WlsServer discoveredServer;

	public CheckWlsServerIsOnCluster(WlsCluster wlsCluster, WlsServer discoveredServer) {
		super(wlsCluster.getDomain());
		this.wlsCluster = wlsCluster;
		this.discoveredServer = discoveredServer;
		setDescription("Check that server " + discoveredServer + " is on cluster " + wlsCluster) ;
	}

	public boolean execute(StepExecutionContext ctx) {
		Collection<String> servernamesOnCluster = domain.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Clusters/" + wlsCluster.getName() + "/Servers");
		String isOn;
		if (servernamesOnCluster.contains(discoveredServer.getName())) {
			isOn = IS_ON_RESULT;
		} else {
			isOn = IS_NOT_ON_RESULT;
		}
		ctx.setAttribute(discoveredServer + SERVER_CLUSTER_SEPERATOR + wlsCluster, isOn);
		return true; //Please not, Needs refactoring, hides the fact that execution might fail
	}

}
