package com.xebialabs.deployit.plugin.wls.step;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;


public class ModifyDeploymentOrderStep extends SimpleWlstExecutingStep {

	private static final String MODIFY_DEPLOYMENT_ORDER_SCRIPT_RESOURCES_PATH = STEP_RESOURCES_PATH + "modify-deployment-order.py";
	static final String BLANK_VERSION = "";

	public ModifyDeploymentOrderStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, int deploymentOrder) {
		this(wlsTarget, artifact, BLANK_VERSION, deploymentOrder);
	}

	public ModifyDeploymentOrderStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, String appVersion, int deploymentOrder) {
		super("Modify the deployment order of " + artifact + " with value " + deploymentOrder, wlsTarget.getDomain(), MODIFY_DEPLOYMENT_ORDER_SCRIPT_RESOURCES_PATH, asArguments(makeArtifactName(artifact, appVersion), BLANK_VERSION + deploymentOrder));
	}

	private static String makeArtifactName(NamedDeployableArtifact artifact, String appVersion) {
		final String prefix;
		if (artifact instanceof WlsSharedLibraryJar) {
			prefix = "Libraries/";
			final File manifestFile = new File(artifact.getLocation());
			final Manifest manifest = readManifest(manifestFile);
			final Attributes mainAttributes = manifest.getMainAttributes();
			final String specVersion = mainAttributes.getValue("Specification-Version");
			final String implVersion = mainAttributes.getValue("Implementation-Version");
			final String extName = mainAttributes.getValue("Extension-Name");
			return prefix + extName + "#" + specVersion + "@" + implVersion;
		} else {
			prefix = "AppDeployments/";
			return prefix + artifact.getName() + (StringUtils.isBlank(appVersion) ? BLANK_VERSION : "#" + appVersion).trim();
		}
	}

	private static Manifest readManifest(File archiveFile) {
		Manifest manifest;
		JarInputStream in = null;
		try {
			in = new JarInputStream(new FileInputStream(archiveFile));
			manifest = in.getManifest();
		} catch (IOException exception) {
			throw new RuntimeIOException("Cannot read manifest file " + archiveFile, exception);
		} finally {
			IOUtils.closeQuietly(in);
		}
		return manifest;
	}
}


