package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;

public class WaitingStep implements Step {
	private long waitTime;

	public WaitingStep(long waitTime) {
		this.waitTime = waitTime;
	}


	public String getDescription() {
		return "Wait for " + this.waitTime + " second(s)";
	}

	public boolean execute(final StepExecutionContext ctx) {
		try {
			Thread.sleep(waitTime * 1000);
		} catch (InterruptedException e) {
			ctx.logError("Interrupted!", e);
			Thread.currentThread().interrupt();
			return false;
		}

		ctx.logOutput("Done waiting");
		return true;
	}
}
