/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.mapping.EjbJarMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.io.Serializable;

@ConfigurationItem(description="A mapping of an EjbJar to a WebLogic target")
public class WlsEjbJarMapping
extends EjbJarMapping<WlsTarget>
implements WlsArtifactMapping {
    @ConfigurationItemProperty(category="Weblogic")
    private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;
    @ConfigurationItemProperty(category="Weblogic", description="Deployment staging mode (default is stage)")
    private WlsStageMode stageMode;
    @ConfigurationItemProperty(category="Weblogic", description="Remote directory where the archives (ear,jar,war) are copied before deploying")
    protected String stagingDirectory;
    @ConfigurationItemProperty(category="Weblogic")
    private WlsDeploymentPlan deploymentPlan;
    @ConfigurationItemProperty(category="Weblogic")
    protected String deploymentPlanStagingDirectory;
    @ConfigurationItemProperty(category="Weblogic")
    protected boolean versionnedArtifact = false;
    @ConfigurationItemProperty(category="Weblogic")
    protected String version;
    @ConfigurationItemProperty(category="Weblogic", description="By default, new applications and modules are configured with a Deployment Order value of 100")
    protected int deploymentOrder = 100;

    public WlsEjbJarMapping() {
    }

    public WlsEjbJarMapping(EjbJar source, WlsTarget target) {
        this(source, target, WlsStageMode.Stage, "");
    }

    public WlsEjbJarMapping(EjbJar source, WlsTarget target, WlsStageMode stageMode, String stagingDirectory) {
        super(source, (Serializable)((Object)target));
        this.stageMode = stageMode;
        this.stagingDirectory = stagingDirectory;
    }

    @Override
    public WlsDeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public void setDeploymentStrategy(WlsDeploymentStrategy strategy) {
        this.deploymentStrategy = strategy;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isVersionnedArtifact() {
        return this.versionnedArtifact;
    }

    @Override
    public int getRetireTimeout() {
        return -1;
    }

    @Override
    public WlsStageMode getStageMode() {
        return this.stageMode == null ? WlsStageMode.Stage : this.stageMode;
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    @Override
    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    @Override
    public WlsDeploymentPlan getDeploymentPlan() {
        return this.deploymentPlan;
    }

    @Override
    public String getDeploymentPlanStagingDirectory() {
        return this.deploymentPlanStagingDirectory;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public void setDeploymentPlan(WlsDeploymentPlan deploymentPlan) {
        this.deploymentPlan = deploymentPlan;
    }

    public void setDeploymentPlanStagingDirectory(String deploymentPlanStagingDirectory) {
        this.deploymentPlanStagingDirectory = deploymentPlanStagingDirectory;
    }

    @Override
    public int getDeploymentOrder() {
        return this.deploymentOrder;
    }

    public void setDeploymentOrder(int deploymentOrder) {
        this.deploymentOrder = deploymentOrder;
    }
}

