/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JmsMapperUtils {
    public static String getJmsModuleName(Change<Deployment> change, WlsTarget target) {
        if (change.getNewRevision() != null) {
            return JmsMapperUtils.getJmsModuleNameFromDeployment((Deployment)change.getNewRevision(), target);
        }
        return JmsMapperUtils.getJmsModuleNameFromDeployment((Deployment)change.getOldRevision(), target);
    }

    private static String getJmsModuleNameFromDeployment(Deployment d, WlsTarget target) {
        String appLabel = d.getSource().getApplication().getLabel();
        String shortLabel = appLabel.replace("Applications/", "");
        return JmsMapperUtils.sanitizeLabel(shortLabel) + "-" + JmsMapperUtils.sanitizeLabel(target.getName());
    }

    private static String sanitizeLabel(String label) {
        int lastSlash = label.lastIndexOf(47);
        if (lastSlash >= 0) {
            label = label.substring(lastSlash + 1);
        }
        return label.replace(' ', '_');
    }

    public static Set<WlsDomain> getDomains(Collection<WlsTarget> targets) {
        HashSet<WlsDomain> domains = new HashSet<WlsDomain>();
        for (WlsTarget each : targets) {
            domains.add(each.getDomain());
        }
        return domains;
    }

    public static String getSubdeploymentName(String jmsModuleName, Set<WlsJmsServer> jmsServers) {
        if (jmsServers.isEmpty()) {
            throw new ResolutionException("at least one jmsServer must be added to the CI (Module: " + jmsModuleName + ")");
        }
        StringBuilder subdeploymentName = null;
        for (WlsJmsServer jmsServer : jmsServers) {
            if (subdeploymentName == null) {
                subdeploymentName = new StringBuilder(jmsServer.getSubdeploymentName(jmsModuleName));
                continue;
            }
            subdeploymentName.append("-").append(jmsServer.getName());
        }
        return subdeploymentName.toString();
    }
}

