/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CreateWlsDataSourceStep
extends SimpleWlstExecutingStep {
    public static final String SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/create-datasource.py";

    public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on cluster " + (Object)((Object)cluster), cluster.getDomain(), SCRIPT_RESOURCE_PATH, CreateWlsDataSourceStep.getArgs(cluster.getTargetObjectName(), wlsDataSource));
    }

    public CreateWlsDataSourceStep(WlsServer server, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on server " + (Object)((Object)server), server.getDomain(), SCRIPT_RESOURCE_PATH, CreateWlsDataSourceStep.getArgs(server.getTargetObjectName(), wlsDataSource));
    }

    public CreateWlsDataSourceStep(WlsDomain domain, Set<WlsTarget> targets, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on domain " + (Object)((Object)domain) + " targeted to " + targets, domain, SCRIPT_RESOURCE_PATH, CreateWlsDataSourceStep.getArgs(CreateWlsDataSourceStep.concatTargets(targets), wlsDataSource));
    }

    private static String concatTargets(Set<WlsTarget> targets) {
        return StringUtils.join((Collection)Collections2.transform(targets, (Function)new Function<WlsTarget, String>(){

            public String apply(WlsTarget from) {
                return from.getTargetObjectName();
            }
        }), (String)";");
    }

    private static List<CmdLineArgument> getArgs(String targetObjectName, WlsDataSource webLogicDatasource) {
        ArrayList<CmdLineArgument> args = new ArrayList<CmdLineArgument>();
        args.add(CmdLineArgument.arg((String)targetObjectName));
        args.add(CmdLineArgument.arg((String)webLogicDatasource.getName()));
        args.add(CmdLineArgument.arg((String)webLogicDatasource.getJndiName()));
        args.add(CmdLineArgument.arg((String)webLogicDatasource.getUri()));
        if (StringUtils.isBlank((String)webLogicDatasource.getUserName())) {
            args.add(CmdLineArgument.arg((String)""));
        } else {
            args.add(CmdLineArgument.arg((String)webLogicDatasource.getUserName()));
        }
        if (StringUtils.isBlank((String)webLogicDatasource.getPassword())) {
            args.add(CmdLineArgument.arg((String)""));
        } else {
            args.add(CmdLineArgument.password((String)webLogicDatasource.getPassword()));
        }
        args.add(CmdLineArgument.arg((String)webLogicDatasource.getDriver()));
        args.add(CmdLineArgument.arg((String)String.valueOf(webLogicDatasource.getInit())));
        args.add(CmdLineArgument.arg((String)String.valueOf(webLogicDatasource.getMax())));
        if (webLogicDatasource.getProperties() != null) {
            args.add(CmdLineArgument.arg((String)webLogicDatasource.getProperties()));
        } else {
            args.add(CmdLineArgument.arg((String)"None"));
        }
        return args;
    }
}

