/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyDeploymentOrderStep
extends SimpleWlstExecutingStep {
    private static final String MODIFY_DEPLOYMENT_ORDER_SCRIPT_RESOURCES_PATH = "com/xebialabs/deployit/plugin/wls/step/modify-deployment-order.py";
    static final String BLANK_VERSION = "";

    public ModifyDeploymentOrderStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, int deploymentOrder) {
        this(wlsTarget, artifact, BLANK_VERSION, deploymentOrder);
    }

    public ModifyDeploymentOrderStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, String appVersion, int deploymentOrder) {
        super("Modify the deployment order of " + artifact + " with value " + deploymentOrder, wlsTarget.getDomain(), MODIFY_DEPLOYMENT_ORDER_SCRIPT_RESOURCES_PATH, ModifyDeploymentOrderStep.asArguments(ModifyDeploymentOrderStep.makeArtifactName(artifact, appVersion), BLANK_VERSION + deploymentOrder));
    }

    private static String makeArtifactName(NamedDeployableArtifact artifact, String appVersion) {
        if (artifact instanceof WlsSharedLibraryJar) {
            String prefix = "Libraries/";
            File manifestFile = new File(artifact.getLocation());
            Manifest manifest = ModifyDeploymentOrderStep.readManifest(manifestFile);
            Attributes mainAttributes = manifest.getMainAttributes();
            String specVersion = mainAttributes.getValue("Specification-Version");
            String implVersion = mainAttributes.getValue("Implementation-Version");
            String extName = mainAttributes.getValue("Extension-Name");
            return prefix + extName + "#" + specVersion + "@" + implVersion;
        }
        String prefix = "AppDeployments/";
        return prefix + artifact.getName() + (StringUtils.isBlank((String)appVersion) ? BLANK_VERSION : "#" + appVersion).trim();
    }

    private static Manifest readManifest(File archiveFile) {
        Manifest manifest;
        JarInputStream in = null;
        try {
            in = new JarInputStream(new FileInputStream(archiveFile));
            manifest = in.getManifest();
        }
        catch (IOException exception) {
            try {
                throw new RuntimeIOException("Cannot read manifest file " + archiveFile, (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return manifest;
    }
}

