/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WlsDeployArtifactStep
extends WlsStepBase {
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-application.py";
    private String targetName;
    private String applicationName;
    private String extension;
    private String applicationLocation;
    private String deploymentPlanLocation;
    private String remoteDeploymentPlanDestination;
    private Map<String, String> properties;
    private PlaceholderFormat placeholderFormat;
    private String appVersion;
    private long retireTimeout = -1L;
    private boolean libraryModule = false;

    public WlsDeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
        this(target, artifact, Collections.emptyMap(), PlaceholderFormat.SPRING);
    }

    public WlsDeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, String appVersion) {
        this(target, artifact, Collections.emptyMap(), PlaceholderFormat.SPRING);
        this.setAppVersion(appVersion);
    }

    public WlsDeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        super(target.getDomain());
        this.targetName = target.getName();
        this.applicationName = artifact.getName();
        this.libraryModule = artifact instanceof WlsSharedLibrary;
        this.extension = this.findOutExtension(artifact);
        this.applicationLocation = artifact.getLocation();
        this.properties = properties;
        this.placeholderFormat = placeholderFormat;
        if (properties == null || properties.isEmpty()) {
            this.setDescription("Deploy " + artifact + " on " + (Object)((Object)target));
        } else {
            this.setDescription("Deploy " + artifact + " on " + (Object)((Object)target) + " while replacing properties in the archive.");
        }
    }

    @Override
    public String getDescription() {
        String desc = super.getDescription();
        if (this.hasDeploymentPlan()) {
            desc = desc + " and a deployment plan";
        }
        return desc;
    }

    private String findOutExtension(NamedDeployableArtifact artifact) {
        try {
            String extension = ".";
            if (this.libraryModule) {
                extension = extension + ((WlsSharedLibrary)artifact).getSharedLibraryType().toString().toLowerCase();
            } else {
                Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
                extension = extension + field.get(artifact).toString();
            }
            return extension;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            int res;
            HostFile uploadedApplication = this.uploadApplication(rhs);
            String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');
            CmdLine cmdLine = new CmdLine();
            cmdLine.addArgument(this.domain.getUsername());
            cmdLine.addPassword(this.domain.getPassword());
            cmdLine.addArgument(this.domain.getConnectUrl());
            cmdLine.addArgument(this.targetName);
            cmdLine.addArgument(this.applicationName);
            cmdLine.addArgument(uploadedApplicationPath);
            cmdLine.addArgument("stageMode");
            cmdLine.addArgument("stage");
            cmdLine.addArgument("upload");
            cmdLine.addArgument("true");
            if (this.hasDeploymentPlan()) {
                HostFile uploadedPan = this.uploadPlan(rhs);
                String uploadedPlanPath = uploadedPan.getPath().replace('\\', '/');
                cmdLine.addArgument("planPath");
                cmdLine.addArgument(uploadedPlanPath);
            }
            if (StringUtils.isNotBlank((String)this.appVersion)) {
                cmdLine.addArgument("versionIdentifier");
                cmdLine.addArgument(this.appVersion);
            }
            if (this.libraryModule) {
                cmdLine.addArgument("libraryModule");
                cmdLine.addArgument("true");
            }
            if (this.retireTimeout > 0L) {
                cmdLine.addArgument("retireTimeout");
                cmdLine.addArgument("" + this.retireTimeout);
            }
            boolean bl = (res = this.executeWlstJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME, cmdLine)) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadPlan(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile planFileToUpload = lhs.getFile(this.deploymentPlanLocation);
            HostFile uploadedPlanFile = rhs.getFile(this.remoteDeploymentPlanDestination);
            HostFile parentFile = uploadedPlanFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            HostFileUtils.copy((HostFile)planFileToUpload, (HostFile)uploadedPlanFile, (HostFileInputStreamTransformer)this.getTransformer());
            HostFile hostFile = uploadedPlanFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile applicationFileToUpload = lhs.getFile(this.applicationLocation);
            HostFile uploadedApplicationFile = rhs.getTempFile(this.applicationName, this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile, (HostFileInputStreamTransformer)this.getTransformer());
            HostFile hostFile = uploadedApplicationFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    private HostFileInputStreamTransformer getTransformer() {
        if (this.properties.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingArchiveHostFileInputTransformer(this.properties, this.placeholderFormat);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setLibraryModule(boolean libraryModule) {
        this.libraryModule = libraryModule;
    }

    public void setDeploymentPlan(WlsDeploymentPlan plan, String remoteDeploymentPlanDestination) {
        this.deploymentPlanLocation = plan.getLocation();
        this.remoteDeploymentPlanDestination = remoteDeploymentPlanDestination;
    }

    public boolean hasDeploymentPlan() {
        return !StringUtils.isBlank((String)this.deploymentPlanLocation) && !StringUtils.isBlank((String)this.remoteDeploymentPlanDestination);
    }

    public boolean isLibraryModule() {
        return this.libraryModule;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        if (StringUtils.isNotBlank((String)this.appVersion) && this.appVersion.contains("/")) {
            throw new ResolutionException("a version should not contain '/', current is " + appVersion);
        }
        if (this.properties == null || this.properties.isEmpty()) {
            this.setDescription("Deploy " + this.applicationName + " version (" + appVersion + ") on " + this.targetName);
        } else {
            this.setDescription("Deploy " + this.applicationName + " version (" + appVersion + ") on " + this.targetName + " while replacing properties in the archive.");
        }
    }

    public long getRetireTimeout() {
        return this.retireTimeout;
    }

    public void setRetireTimeout(long retireTimeout) {
        this.retireTimeout = retireTimeout;
    }
}

