#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

scriptname = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

print "Connecting to WebLogic"
connect(user, password, url)
edit()
startEdit()

jmsModuleName = sys.argv.pop(0)
queueName = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
loadBalancingPolicy = sys.argv.pop(0)
forwardDelay = sys.argv.pop(0)

numMemberQueues = sys.argv.pop(0)
memberQueueNames = []
for i in range(0, int(numMemberQueues)):
  memberQueueNames.append(sys.argv.pop(0))

print "Creating JMS Distributed Queue " + queueName + " in JMS Module " + jmsModuleName + " with members " + str(memberQueueNames)
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName)
cmo.createDistributedQueue(queueName)
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/DistributedQueues/' + queueName)
cmo.setJNDIName(jndiName)
cmo.setLoadBalancingPolicy(loadBalancingPolicy)
cmo.setForwardDelay(int(forwardDelay))

for memberQueueName in memberQueueNames:
	print "Adding queue " + memberQueueName + " to the distributed queue" 
	cmo.createDistributedQueueMember(memberQueueName)

print "Saving configuration"
save()
disconnect('true')
exit('y')
