/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.io.Serializable;

@ConfigurationItem(description="A mapping of an EAR to a WebLogic target")
public class WlsEarMapping
extends EarMapping<WlsTarget>
implements WlsArtifactMapping {
    @ConfigurationItemProperty(required=false)
    private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;
    @ConfigurationItemProperty(required=false, description="Deployment staging mode (default is stage)")
    private WlsStageMode stageMode;
    @ConfigurationItemProperty(required=false, description="Remote directory where the archives (ear,jar,war) are copied before deploying")
    protected String stagingDirectory;
    @ConfigurationItemProperty(required=false)
    private WlsDeploymentPlan deploymentPlan;
    @ConfigurationItemProperty(required=false)
    protected String deploymentPlanStagingDirectory;

    public WlsEarMapping() {
    }

    public WlsEarMapping(Ear source, WlsTarget target, String virtualHost) {
        super(source, (Serializable)((Object)target), virtualHost);
    }

    public WlsEarMapping(Ear source, WlsTarget target, String virtualHost, WlsStageMode stageMode, String stagingDirectory) {
        super(source, (Serializable)((Object)target), virtualHost);
        this.stageMode = stageMode;
        this.stagingDirectory = stagingDirectory;
    }

    @Override
    public WlsStageMode getStageMode() {
        return this.stageMode == null ? WlsStageMode.Stage : this.stageMode;
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    @Override
    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    @Override
    public WlsDeploymentPlan getDeploymentPlan() {
        return this.deploymentPlan;
    }

    @Override
    public String getDeploymentPlanStagingDirectory() {
        return this.deploymentPlanStagingDirectory;
    }

    @Override
    public WlsDeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public void setDeploymentStrategy(WlsDeploymentStrategy strategy) {
        this.deploymentStrategy = strategy;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public void setDeploymentPlan(WlsDeploymentPlan deploymentPlan) {
        this.deploymentPlan = deploymentPlan;
    }

    public void setDeploymentPlanStagingDirectory(String deploymentPlanStagingDirectory) {
        this.deploymentPlanStagingDirectory = deploymentPlanStagingDirectory;
    }
}

