package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArchiveArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.local.LocalFile;

public class WlsArtifactProcessor {

	@SuppressWarnings("unchecked")
    @PrePlanProcessor
	public Step<?> setVersionIdentifiers(DeltaSpecification spec) {

		final String appVersion = spec.getDeployedApplication().getVersion().getVersion();
		final String appName = spec.getDeployedApplication().getVersion().getApplication().getName();
		final String defaultVersion = appName + "-" + appVersion;

		for (Delta delta : spec.getDeltas()) {
			final Deployed<?, ?> deployed = delta.getDeployed();
			if (deployed instanceof ExtensibleDeployedArtifact) {
				setVersionIdentifier((ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact>)deployed, defaultVersion);
			}
		}
		return null;
	}

	/**
	 * Update the version and name property depending of the content of the manifest file.
	 * 
	 * @param deployed
	 * @param defaultVersion
	 */
	private void setVersionIdentifier(ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact> deployed, String defaultVersion) {
		final Artifact artifact = (Artifact) deployed.getDeployable();
		if (deployed.isVersioned()) {
			final File manifestFile = ((LocalFile)artifact.getFile()).getFile();
			final Manifest manifest = readManifest(manifestFile);
			final Attributes mainAttributes = manifest.getMainAttributes();
			final String extName = mainAttributes.getValue("Extension-Name");
			if (StringUtils.isBlank(extName)) {
				deployed.setVersionIdentifier(defaultVersion);
				return;
			}
			
			//TODO:is it really necessary? revisit it while doing the related story(DEPLOYITPB-1867)
			/*
			final String originalId = deployed.getId();
			int indexOfLastSlash = originalId.lastIndexOf('/');
			if (indexOfLastSlash > -1) {
				String newId = originalId.substring(0, indexOfLastSlash) + "/" + extName;
				deployed.setId(newId);
			}*/

			final String specVersion = mainAttributes.getValue("Specification-Version");
			final String implVersion = mainAttributes.getValue("Implementation-Version");
			deployed.setVersionIdentifier(StringUtils.isBlank(implVersion) ? specVersion : specVersion + "@" + implVersion);
		}
	}

	private Manifest readManifest(File archiveFile) {
		Manifest manifest;
		JarInputStream in = null;
		try {
			in = new JarInputStream(new java.io.FileInputStream(archiveFile));
			manifest = in.getManifest();
		} catch (IOException exception) {
			throw new RuntimeException("Cannot read manifest file " + archiveFile, exception);
		} finally {
			IOUtils.closeQuietly(in);
		}
		return manifest;
	}

}
