/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Metadata(description="WebLogic Cluster which defines groups of WebLogic servers that work together to increase scalability and reliability")
public class Cluster
extends BaseContainer
implements WlsContainer,
JmsTarget {
    @Property(required=true, asContainment=true, description="The domain to which the WebLogic Cluster belongs.  'asContainment'=true, means a Cluster is 'contained' under a Domain")
    private Domain domain;
    @Property(description="Servers in the WebLogic Cluster")
    private Set<Server> servers = new HashSet<Server>();

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Cluster";
    }

    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "wls/container/inspect-cluster.py", (Map)pythonVars, "Inspect " + this));
    }

    @Override
    public Set<Host> getHosts() {
        HashSet hosts = Sets.newHashSet();
        for (Server server : this.servers) {
            hosts.addAll(server.getHosts());
        }
        return hosts;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void setServers(Set<Server> servers) {
        this.servers = servers;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public PythonManagingContainer getManagingContainer() {
        return this.domain;
    }
}

