/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class WlsArtifactProcessor {
    private static final Function<Delta, ExtensibleDeployedArtifact> TO_DEPLOYED = new Function<Delta, ExtensibleDeployedArtifact>(){

        public ExtensibleDeployedArtifact apply(Delta delta) {
            Deployed deployed = delta.getDeployed();
            return deployed instanceof ExtensibleDeployedArtifact ? (ExtensibleDeployedArtifact)deployed : null;
        }
    };
    private static final Predicate<ExtensibleDeployedArtifact> IS_VERSIONED = new Predicate<ExtensibleDeployedArtifact>(){

        public boolean apply(ExtensibleDeployedArtifact input) {
            return Predicates.notNull().apply((Object)input) && (input.isVersioned() || this.isSharedLibrary(input));
        }

        private boolean isSharedLibrary(ExtensibleDeployedArtifact input) {
            Type inputType = input.getType();
            return inputType.equals((Object)ExtensibleDeployedArtifact.DEPLOYED_SHARED_LIB_WAR);
        }
    };

    @PrePlanProcessor
    public Step<?> setVersionIdentifiers(DeltaSpecification spec) {
        String appVersion = spec.getDeployedApplication().getVersion().getVersion();
        String appName = spec.getDeployedApplication().getVersion().getApplication().getName();
        String defaultVersion = appName + "-" + appVersion;
        VersionSetter version = new VersionSetter(defaultVersion);
        for (ExtensibleDeployedArtifact artifact : Iterables.filter((Iterable)Iterables.transform((Iterable)spec.getDeltas(), TO_DEPLOYED), IS_VERSIONED)) {
            version.apply(artifact);
        }
        return null;
    }

    private class VersionSetter
    implements Function<ExtensibleDeployedArtifact, Void> {
        private final String defaultVersion;

        public VersionSetter(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public Void apply(ExtensibleDeployedArtifact deployed) {
            Artifact artifact = (Artifact)deployed.getDeployable();
            File manifestFile = ((LocalFile)artifact.getFile()).getFile();
            Manifest manifest = this.readManifest(manifestFile);
            Attributes mainAttributes = manifest.getMainAttributes();
            String extName = mainAttributes.getValue("Extension-Name");
            deployed.setVersioned(true);
            if (Strings.isNullOrEmpty((String)extName)) {
                deployed.setVersionIdentifier(this.defaultVersion);
            } else {
                String specVersion = mainAttributes.getValue("Specification-Version");
                String implVersion = mainAttributes.getValue("Implementation-Version");
                deployed.setVersionIdentifier(Strings.isNullOrEmpty((String)implVersion) ? specVersion : specVersion + "@" + implVersion);
            }
            return null;
        }

        private Manifest readManifest(File archiveFile) {
            Manifest manifest;
            JarInputStream in = null;
            try {
                in = new JarInputStream(new FileInputStream(archiveFile));
                manifest = in.getManifest();
            }
            catch (IOException exception) {
                try {
                    throw new RuntimeException("Cannot read manifest file " + archiveFile, exception);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(in);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)in);
            return manifest;
        }
    }
}

