/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;

public class DeleteArtifactStep
implements DeploymentStep {
    private final int order;
    private final Host host;
    private final String artifactPath;

    public DeleteArtifactStep(int order, Host host, String artifactPath) {
        this.order = order;
        this.host = host;
        this.artifactPath = artifactPath;
    }

    public String getDescription() {
        return String.format("Delete artifact %s", this.artifactPath);
    }

    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        OverthereConnection connection = this.host.getConnection();
        OverthereFile fileToDelete = connection.getFile(this.artifactPath);
        if (fileToDelete.exists()) {
            ctx.logOutput("Deleting " + this.artifactPath);
            fileToDelete.deleteRecursively();
            return Step.Result.Success;
        }
        ctx.logOutput(String.format("Nothing exist at %s, skipping deletion", this.artifactPath));
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeleteArtifactStep)) {
            return false;
        }
        DeleteArtifactStep other = (DeleteArtifactStep)obj;
        return this.host.equals((Object)other.host) && this.artifactPath.equals(other.artifactPath);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.artifactPath.hashCode();
        return result;
    }
}

