package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("serial")
public class StartWlsServerWithScriptStep implements DeploymentStep {


	private final int order;
	private final Server server;

	public StartWlsServerWithScriptStep(int order, Server server) {
		checkState(server.getHost() != null, "Can only start a wls.Server with a script when it its host property has been set");
		this.order = order;
		this.server = server;
	}

	@Override
	public String getDescription() {
		return String.format("Start Weblogic server %s using %s", server, server.getStartCommand());
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
		CmdLine cmdLine = new CmdLine();
		for (String arg : Splitter.on(" ").split(server.getStartCommand()))
			cmdLine.addArgument(arg);

		OverthereConnection connection = server.getHost().getConnection();
		int res = connection.execute(new ExecutionContextOverthereProcessOutputHandler(ctx), cmdLine);
		return res == 0 ? Result.Success : Result.Fail;
	}

	@Override
	public int getOrder() {
		return order;
	}

}
