/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcessOutputHandler;

public class StartWlsServerWithScriptStep
implements DeploymentStep {
    private final int order;
    private final Server server;

    public StartWlsServerWithScriptStep(int order, Server server) {
        Preconditions.checkState((server.getHost() != null ? 1 : 0) != 0, (Object)"Can only start a wls.Server with a script when it its host property has been set");
        this.order = order;
        this.server = server;
    }

    public String getDescription() {
        return String.format("Start Weblogic server %s using %s", this.server, this.server.getStartCommand());
    }

    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        CmdLine cmdLine = new CmdLine();
        for (String arg : Splitter.on((String)" ").split((CharSequence)this.server.getStartCommand())) {
            cmdLine.addArgument(arg);
        }
        OverthereConnection connection = this.server.getHost().getConnection();
        int res = connection.execute((OverthereProcessOutputHandler)new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)ctx), cmdLine);
        return res == 0 ? Step.Result.Success : Step.Result.Fail;
    }

    public int getOrder() {
        return this.order;
    }
}

