/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class WlsArtifactProcessor {
    private static final Function<Delta, ExtensibleDeployedArtifact> TO_DEPLOYED = new Function<Delta, ExtensibleDeployedArtifact>(){

        public ExtensibleDeployedArtifact apply(Delta delta) {
            Deployed deployed = delta.getDeployed();
            return deployed instanceof ExtensibleDeployedArtifact ? (ExtensibleDeployedArtifact)deployed : null;
        }
    };
    private static final Predicate<ExtensibleDeployedArtifact> IS_VERSIONED = new Predicate<ExtensibleDeployedArtifact>(){

        public boolean apply(ExtensibleDeployedArtifact extensibleDeployedArtifact) {
            return Predicates.notNull().apply((Object)extensibleDeployedArtifact) && (extensibleDeployedArtifact.isVersioned() || this.isSharedLibrary(extensibleDeployedArtifact));
        }

        private boolean isSharedLibrary(ExtensibleDeployedArtifact extensibleDeployedArtifact) {
            Type type = extensibleDeployedArtifact.getType();
            return type.equals((Object)ExtensibleDeployedArtifact.DEPLOYED_SHARED_LIB_WAR);
        }
    };

    @PrePlanProcessor
    public Step<?> setVersionIdentifiers(DeltaSpecification deltaSpecification) {
        String string = deltaSpecification.getDeployedApplication().getVersion().getVersion();
        String string2 = deltaSpecification.getDeployedApplication().getVersion().getApplication().getName();
        String string3 = string2 + "-" + string;
        VersionSetter versionSetter = new VersionSetter(string3);
        for (ExtensibleDeployedArtifact extensibleDeployedArtifact : Iterables.filter((Iterable)Iterables.transform((Iterable)deltaSpecification.getDeltas(), TO_DEPLOYED), IS_VERSIONED)) {
            versionSetter.apply(extensibleDeployedArtifact);
        }
        return null;
    }

    private class VersionSetter
    implements Function<ExtensibleDeployedArtifact, Void> {
        private final String defaultVersion;

        public VersionSetter(String string) {
            this.defaultVersion = string;
        }

        public Void apply(ExtensibleDeployedArtifact extensibleDeployedArtifact) {
            Artifact artifact = (Artifact)extensibleDeployedArtifact.getDeployable();
            File file = ((LocalFile)artifact.getFile()).getFile();
            Manifest manifest = this.readManifest(file);
            if (manifest == null) {
                return null;
            }
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue("Extension-Name");
            extensibleDeployedArtifact.setVersioned(true);
            if (Strings.isNullOrEmpty((String)string)) {
                extensibleDeployedArtifact.setVersionIdentifier(this.defaultVersion);
            } else {
                String string2 = attributes.getValue("Specification-Version");
                String string3 = attributes.getValue("Implementation-Version");
                extensibleDeployedArtifact.setVersionIdentifier(Strings.isNullOrEmpty((String)string3) ? string2 : string2 + "@" + string3);
            }
            return null;
        }

        private Manifest readManifest(File file) {
            Manifest manifest;
            JarInputStream jarInputStream = null;
            try {
                jarInputStream = new JarInputStream(new FileInputStream(file));
                manifest = jarInputStream.getManifest();
            }
            catch (IOException iOException) {
                try {
                    throw new RuntimeException("Cannot read manifest file " + file, iOException);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(jarInputStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)jarInputStream);
            return manifest;
        }
    }
}

