package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static com.xebialabs.deployit.plugin.api.deployment.specification.Operation.DESTROY;

public class Predicates2 {

	public static Predicate<Type> subtypeOf(Type type) {
		return new IsSubtypeOf(type);
	}

	public static Predicate<ConfigurationItem> instanceOf(Type type) {
		return com.google.common.base.Predicates.compose(subtypeOf(type),
				new Function<ConfigurationItem, Type>() {
					@Override
					public Type apply(ConfigurationItem input) {
						return input.getType();
					}
				});
	}

	public static Predicate<Delta> deltaOf(Type type) {
		return com.google.common.base.Predicates.compose(instanceOf(type),
				extractDeployed());
	}

	public static Function<Delta, Deployed<?, ?>> extractDeployed() {
		return new ExtractDeployed();
	}

	public static Predicate<Delta> operationIs(Operation operationToMatch) {
		return new OperationEquals(operationToMatch);
	}

	private static class OperationEquals implements Predicate<Delta> {
		private final Operation operationToMatch;

		protected OperationEquals(Operation operationToMatch) {
			this.operationToMatch = operationToMatch;
		}

		@Override
		public boolean apply(Delta input) {
			return input.getOperation().equals(operationToMatch);
		}
	}

	private static class IsSubtypeOf implements Predicate<Type> {
		private Type typeToMatch;

		public IsSubtypeOf(Type typeToMatch) {
			this.typeToMatch = typeToMatch;
		}

		@Override
		public boolean apply(Type input) {
			return input.instanceOf(typeToMatch);
		}
	}

	private static class ExtractDeployed implements Function<Delta, Deployed<?, ?>> {
		@Override
		public Deployed<?, ?> apply(Delta input) {
			return (input.getOperation().equals(DESTROY)
					? input.getPrevious()
					: input.getDeployed());
		}
	}
}
