/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.Predicates2;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedAndCopiedArtifactLifeCycleContributor {
    static final int SHIFT_RESTART_ORDERS = 1;
    protected static final Logger logger = LoggerFactory.getLogger(DeployedAndCopiedArtifactLifeCycleContributor.class);

    @Contributor
    public void restartAfterDeployResourcesOrCopiedArtifact(Deltas deltas, DeploymentPlanningContext result) {
        Set restartableDeployed = Sets.filter(this.gatherTargets(deltas.getDeltas()), (Predicate)new Predicate<Deployed<?, ?>>(){

            public boolean apply(Deployed<?, ?> deployed) {
                boolean restartTarget = (Boolean)deployed.getProperty("restartTarget");
                return restartTarget;
            }
        });
        logger.debug("restartable deployeds {}", (Object)restartableDeployed);
        HashMap ordersByContainer = Maps.newHashMap();
        for (Deployed target : restartableDeployed) {
            int createOrder = (Integer)target.getProperty("createOrder");
            WlsContainer container = (WlsContainer)target.getContainer();
            if (!ordersByContainer.containsKey(container)) {
                ordersByContainer.put(container, 0);
            }
            if (createOrder <= (Integer)ordersByContainer.get(container)) continue;
            ordersByContainer.put(container, createOrder);
        }
        Collection steps = Maps.transformEntries((Map)ordersByContainer, (Maps.EntryTransformer)new Maps.EntryTransformer<WlsContainer, Integer, List<DeploymentStep>>(){

            public List<DeploymentStep> transformEntry(WlsContainer container, Integer order) {
                logger.debug("create stop/start step for {} --> {} ", (Object)container, (Object)order);
                ImmutableList.Builder builder = new ImmutableList.Builder();
                builder.add((Object)new StopWlsTargetStep(order + 1, container));
                for (Server s : container.getServers()) {
                    switch (s.getDomain().getStartMode()) {
                        case NodeManager: {
                            builder.add((Object)new StartWlsTargetStep(order + 1, s));
                            break;
                        }
                        case Script: {
                            builder.add((Object)new StartWlsServerWithScriptStep(order + 1, s));
                        }
                    }
                }
                return builder.build();
            }
        }).values();
        for (List step : steps) {
            result.addSteps((Collection)step);
        }
    }

    private Set<Deployed<?, ?>> gatherTargets(List<Delta> operations) {
        logger.error("DeployedAndCopiedArtifactLifeCycleContributor.gatherTargets");
        Type resourcesType = DescriptorRegistry.getDescriptor((String)"wls.Resource").getType();
        Type copiedArtifactType = DescriptorRegistry.getDescriptor((String)"wls.CopiedArtifact").getType();
        Iterable filter = Iterables.filter(operations, (Predicate)Predicates.and((Predicate)Predicates.not(Predicates2.operationIs(Operation.NOOP)), (Predicate)Predicates.or(Predicates2.deltaOf(resourcesType), Predicates2.deltaOf(copiedArtifactType))));
        Iterable transform = Iterables.transform((Iterable)filter, Predicates2.extractDeployed());
        HashSet deployeds = Sets.newHashSet((Iterable)transform);
        logger.debug("deployed {}", (Object)deployeds);
        return deployeds;
    }
}

