/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="WebLogic Cluster which defines groups of WebLogic servers that work together to increase scalability and reliability")
public class Cluster
extends BaseContainer
implements WlsContainer,
JmsTarget {
    protected final Map<String, Object> context = ImmutableMap.of((Object)"container", (Object)this);
    @Property(required=true, asContainment=true, description="The domain to which the WebLogic Cluster belongs.  'asContainment'=true, means a Cluster is 'contained' under a Domain")
    private Domain domain;
    @Property(description="Servers in the WebLogic Cluster")
    private Set<Server> servers = new HashSet<Server>();
    @Property(required=true, defaultValue="80", hidden=true)
    private int startOrder;
    @Property(required=true, defaultValue="20", hidden=true)
    private int stopOrder;
    private static final String START_CONTROL_TASK = "start";
    private static final String STOP_CONTROL_TASK = "stop";

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Cluster";
    }

    @Inspect
    public void inspect(InspectionPlanningContext inspectionPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", this);
        inspectionPlanningContext.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "wls/container/inspect-cluster.py", (Map)hashMap, "Inspect " + this));
    }

    @Override
    public Set<Host> getHosts() {
        HashSet hashSet = Sets.newHashSet();
        for (Server server : this.servers) {
            hashSet.addAll(server.getHosts());
        }
        return hashSet;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void setServers(Set<Server> set) {
        this.servers = set;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public PythonManagingContainer getManagingContainer() {
        return this.domain;
    }

    @Override
    public int getStartOrder() {
        return this.startOrder;
    }

    @Override
    public int getStopOrder() {
        return this.stopOrder;
    }

    public List<Step<?>> controlTaskDispatch(String string) {
        PropertyDescriptor propertyDescriptor;
        if (string.equals(STOP_CONTROL_TASK)) {
            return ImmutableList.of((Object)((Object)new StopWlsTargetStep(1, this)));
        }
        if (string.equals(START_CONTROL_TASK)) {
            switch (this.getDomain().getStartMode()) {
                case NodeManager: {
                    return ImmutableList.of((Object)((Object)new StartWlsTargetStep(1, this)));
                }
                case Script: {
                    return Lists.transform((List)Lists.newArrayList(this.getServers()), (Function)new Function<Server, Step<?>>(){

                        public Step<?> apply(Server server) {
                            return new StartWlsServerWithScriptStep(1, server);
                        }
                    });
                }
            }
        }
        Preconditions.checkArgument(((propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(string + "PythonScript")) != null ? 1 : 0) != 0, (String)"Control task script property '%sPythonScript' not defined for CI type %s", (Object[])new Object[]{string, this.getType()});
        return ImmutableList.of((Object)new PythonDeploymentStep(1, this.getManagingContainer(), propertyDescriptor.get((ConfigurationItem)this) + ".py", this.context, "Executing " + string));
    }
}

