/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="WebLogic Server that runs in its own Java Virtual Machine (JVM) and has its own configuration")
public class Server
extends BaseContainer
implements WlsContainer,
JmsTarget {
    protected final Map<String, Object> context = ImmutableMap.of((Object)"container", (Object)this);
    @Property(required=true, description="Port for the server runs on")
    private int port;
    @Property(required=true, asContainment=true, description="WebLogic domain to which this server belongs. 'asContainment'=true, means a Server is 'contained' under a Domain")
    private Domain domain;
    @Property(required=false, description="Host on which this server is running, needed to perform no-stage deployments and to start the server via a script")
    private Host host;
    @Property(required=false, label="Managed server start command", description="Command that should be executed to start the managed server.")
    private String startCommand;
    @Property(required=false, label="Managed server stop command", description="Command that should be executed to stop the managed server.")
    private String stopCommand;
    @Property(required=false, description="Environment variables for server", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();
    @Property(required=true, defaultValue="80", hidden=true)
    private int startOrder;
    @Property(required=true, defaultValue="20", hidden=true)
    private int stopOrder;
    private static final String START_CONTROL_TASK = "start";
    private static final String STOP_CONTROL_TASK = "stop";

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Server";
    }

    @Inspect
    public void inspect(InspectionPlanningContext inspectionPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", this);
        inspectionPlanningContext.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "wls/container/inspect-server.py", (Map)hashMap, "Inspect " + this));
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public Set<Host> getHosts() {
        Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Can only perform no-stage deployments to server that has their host property set");
        return Collections.singleton(this.host);
    }

    public Cluster getClusterIfAny() {
        Set<Cluster> set = this.domain.getClusters();
        for (Cluster cluster : set) {
            if (!cluster.getServers().contains(this)) continue;
            return cluster;
        }
        return null;
    }

    @Override
    public Set<Server> getServers() {
        return Collections.singleton(this);
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String string) {
        this.startCommand = string;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String string) {
        this.stopCommand = string;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.domain;
    }

    @Override
    public int getStartOrder() {
        return this.startOrder;
    }

    @Override
    public int getStopOrder() {
        return this.stopOrder;
    }

    public List<Step<?>> controlTaskDispatch(String string) {
        PropertyDescriptor propertyDescriptor;
        if (string.equals(STOP_CONTROL_TASK)) {
            return ImmutableList.of((Object)((Object)new StopWlsTargetStep(1, this)));
        }
        if (string.equals(START_CONTROL_TASK)) {
            switch (this.getDomain().getStartMode()) {
                case NodeManager: {
                    return ImmutableList.of((Object)((Object)new StartWlsTargetStep(1, this)));
                }
                case Script: {
                    return ImmutableList.of((Object)((Object)new StartWlsServerWithScriptStep(1, this)));
                }
            }
        }
        Preconditions.checkArgument(((propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(string + "PythonScript")) != null ? 1 : 0) != 0, (String)"Control task script property '%sPythonScript' not defined for CI type %s", (Object[])new Object[]{string, this.getType()});
        return ImmutableList.of((Object)new PythonDeploymentStep(1, this.getManagingContainer(), propertyDescriptor.get((ConfigurationItem)this) + ".py", this.context, "Executing " + string));
    }
}

