/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WaitingStep;
import java.util.HashSet;
import java.util.Set;

public class ArtifactDeploymentContributor {
    private static final String UPLOAD_ARTIFACT_STEPS = "uploadArtifactSteps";
    private static final String WAITING_STEP_INTERVAL = "waitingStepInterval";
    private static final String DELETE_ARTIFACT_STEPS = "deleteArtifactStep";

    @Contributor
    public void contributeArtifactUploadStepForNoStage(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        for (UploadArtifactStep uploadArtifactStep : ArtifactDeploymentContributor.getUploadArtifactSteps(deploymentPlanningContext)) {
            deploymentPlanningContext.addStep((DeploymentStep)uploadArtifactStep);
        }
    }

    @Contributor
    public void contributeArtifactDeleteStepForNoStage(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        for (DeleteArtifactStep deleteArtifactStep : ArtifactDeploymentContributor.getDeleteArtifactSteps(deploymentPlanningContext)) {
            deploymentPlanningContext.addStep((DeploymentStep)deleteArtifactStep);
        }
    }

    @Contributor
    public void contributeWaitStepForSideBySideDeploymentStrategy(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        if (deploymentPlanningContext.getAttribute(WAITING_STEP_INTERVAL) != null) {
            deploymentPlanningContext.addStep((DeploymentStep)new WaitingStep(94, (Long)deploymentPlanningContext.getAttribute(WAITING_STEP_INTERVAL)));
        }
    }

    public static void addUploadArtifactStep(DeploymentPlanningContext deploymentPlanningContext, UploadArtifactStep uploadArtifactStep) {
        ArtifactDeploymentContributor.getUploadArtifactSteps(deploymentPlanningContext).add(uploadArtifactStep);
    }

    public static void addDeleteArtifactStep(DeploymentPlanningContext deploymentPlanningContext, DeleteArtifactStep deleteArtifactStep) {
        ArtifactDeploymentContributor.getDeleteArtifactSteps(deploymentPlanningContext).add(deleteArtifactStep);
    }

    public static void setWaitStepInterval(DeploymentPlanningContext deploymentPlanningContext, long l) {
        if (deploymentPlanningContext.getAttribute(WAITING_STEP_INTERVAL) != null) {
            long l2 = (Long)deploymentPlanningContext.getAttribute(WAITING_STEP_INTERVAL);
            if (l > l2) {
                deploymentPlanningContext.setAttribute(WAITING_STEP_INTERVAL, (Object)l);
            }
        } else {
            deploymentPlanningContext.setAttribute(WAITING_STEP_INTERVAL, (Object)l);
        }
    }

    private static Set<UploadArtifactStep> getUploadArtifactSteps(DeploymentPlanningContext deploymentPlanningContext) {
        HashSet hashSet = (HashSet)deploymentPlanningContext.getAttribute(UPLOAD_ARTIFACT_STEPS);
        if (hashSet == null) {
            hashSet = new HashSet();
            deploymentPlanningContext.setAttribute(UPLOAD_ARTIFACT_STEPS, hashSet);
        }
        return hashSet;
    }

    private static Set<DeleteArtifactStep> getDeleteArtifactSteps(DeploymentPlanningContext deploymentPlanningContext) {
        HashSet hashSet = (HashSet)deploymentPlanningContext.getAttribute(DELETE_ARTIFACT_STEPS);
        if (hashSet == null) {
            hashSet = new HashSet();
            deploymentPlanningContext.setAttribute(DELETE_ARTIFACT_STEPS, hashSet);
        }
        return hashSet;
    }
}

