/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.StartMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LifeCycleContributor {
    @Contributor
    public void stopContainers(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Set<WlsContainer> set = this.gatherTargets(deltas.getDeltas());
        for (WlsContainer wlsContainer : set) {
            deploymentPlanningContext.addStep((DeploymentStep)new StopWlsTargetStep(wlsContainer.getStopOrder(), wlsContainer));
        }
    }

    @Contributor
    public void startContainers(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Set<WlsContainer> set = this.gatherTargets(deltas.getDeltas());
        block5: for (WlsContainer wlsContainer : set) {
            StartMode startMode = wlsContainer.getDomain().getStartMode();
            switch (startMode) {
                case NodeManager: {
                    deploymentPlanningContext.addStep((DeploymentStep)new StartWlsTargetStep(wlsContainer.getStartOrder(), wlsContainer));
                    break;
                }
                case Script: {
                    for (Server server : wlsContainer.getServers()) {
                        deploymentPlanningContext.addStep((DeploymentStep)new StartWlsServerWithScriptStep(wlsContainer.getStartOrder(), server));
                    }
                    continue block5;
                }
                case WindowsService: {
                    throw new RuntimeException("The Windows Service mode has not been implemented yet");
                }
            }
        }
    }

    private Set<WlsContainer> gatherTargets(List<Delta> list) {
        HashSet<WlsContainer> hashSet = new HashSet<WlsContainer>();
        for (Delta delta : list) {
            this.addTarget(hashSet, delta.getDeployed());
            this.addTarget(hashSet, delta.getPrevious());
        }
        return hashSet;
    }

    private void addTarget(Set<WlsContainer> set, Deployed<?, ?> deployed) {
        ExtensibleDeployedArtifact extensibleDeployedArtifact;
        DeploymentStrategy deploymentStrategy;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof ExtensibleDeployedArtifact && (deploymentStrategy = (extensibleDeployedArtifact = (ExtensibleDeployedArtifact)deployed).getRedeploymentStrategy()) == DeploymentStrategy.STOP_START) {
            set.add((WlsContainer)deployed.getContainer());
        }
    }
}

