package com.xebialabs.deployit.plugin.wls.contributor;

import java.util.Collection;
import java.util.Map;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.wls.CustomWlsOrders.DESTROY_JMS_MODULES;

public class JmsModuleDestructor {

    private static final String DESTROY_WLS_JMS_MODULE = "wls/jms/cleanup-jms-module.py";

    @Contributor
    public void destroyJmsModule(Deltas deltas, DeploymentPlanningContext ctx) {
        Multimap<String, Domain> jmsModulesToBeDestroyed = populateModuleDeltasMap(deltas);

        for (String eachModule : jmsModulesToBeDestroyed.keySet()) {
            Collection<Domain> domainsToRemoveFrom = jmsModulesToBeDestroyed.get(eachModule);
            for (Domain eachDomain : domainsToRemoveFrom) {
                addStepToRemoveJmsModuleFromDomain(ctx, eachModule, eachDomain);
            }
        }
    }

    private static void addStepToRemoveJmsModuleFromDomain(DeploymentPlanningContext ctx, String eachModule, Domain eachDomain) {
        Map<String, Object> pythonVars = newHashMap();
        pythonVars.put("jmsModuleName", eachModule);
        ctx.addStep(new PythonDeploymentStep(DESTROY_JMS_MODULES, eachDomain, DESTROY_WLS_JMS_MODULE, pythonVars, "Cleaning up jms module:" + eachModule
                + " in domain:" + eachDomain));
    }

    @SuppressWarnings("rawtypes")
    private static Multimap<String, Domain> populateModuleDeltasMap(Deltas deltas) {
        Multimap<String, Domain> moduleOperationsMap = HashMultimap.create();
        for (Delta each : deltas.getDeltas()) {
            if (each.getOperation() == Operation.DESTROY || each.getOperation() == Operation.MODIFY) {
                Deployed deployed = each.getPrevious() != null ? each.getPrevious() : each.getDeployed();
                if (JmsResource.class.isAssignableFrom(each.getPrevious().getClass())) {
                    String jmsModuleName = ((JmsResource) deployed).getJmsModuleName();
                    moduleOperationsMap.put(jmsModuleName, ((JmsTarget) deployed.getContainer()).getDomain());
                }
            }
        }
        return moduleOperationsMap;
    }
}
